#!/bin/sh -e

# called by uscan with '--upstream-version' <version> <file>
TAR=libjgroups-java_$2.orig.tar.gz
DIR=libjgroups-java-$2.orig

# clean up the upstream tarball
unzip $3
mv JGroups-* $DIR

# replace CC licensed files by my own simple implementation
cp -f debian/annotations/* $DIR/src/org/jgroups/annotations/

tar -c -z -f $TAR --exclude '*.jar' --exclude '*/out/*' --exclude '*/lib/*' $DIR
rm -rf $3 $DIR

# move to directory 'tarballs'
if [ -r .svn/deb-layout ]; then
  . .svn/deb-layout
  mv $TAR $origDir
  echo "moved $TAR to $origDir"
fi
