/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.remoting.util;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.jboss.remoting.transport.servlet.ServletServerInvokerMBean;


/**
 * @author <a href="ron.sigal@jboss.com">Ron Sigal</a>
 * @version $Revision: 1.1 $
 * <p>
 * Copyright May 28, 2008
 * </p>
 */
public class ServletSecurityUtility
{
   static public byte[] processRequest(final ServletServerInvokerMBean invoker,
         final HttpServletRequest request,
         final byte[] byteArray,
         final HttpServletResponse response)
   throws ServletException, IOException
   {
      if (SecurityUtility.skipAccessControl())
      {
         return invoker.processRequest(request, byteArray, response);
      }

      try
      {
         return (byte[]) AccessController.doPrivileged( new PrivilegedExceptionAction()
         {
            public Object run() throws ServletException, IOException
            {
               return invoker.processRequest(request, byteArray, response);
            }
         });
      }
      catch (PrivilegedActionException e)
      {
         Throwable cause = e.getCause();
         if (cause instanceof ServletException)
            throw (ServletException) cause;
         else
            throw (IOException) e.getCause();
      }  
   }
}
