/*
 * JBoss, Home of Professional Open Source
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.test.kernel.deployment.support.container;

/**
 * @param <T> the type
 * @author Scott.Stark@jboss.org
 * @version $Revision: 71195 $
 */
public class BeanContainer<T>
{
   private BeanPool<T> pool;

   
   public BeanPool<T> getPool()
   {
      return pool;
   }
   public void setPool(BeanPool<T> pool)
   {
      this.pool = pool;
   }

   @SuppressWarnings("unchecked")
   public T getBean()
      throws Throwable
   {
      T bean = pool.createBean();
      return bean;
   }
   public void destroyBean(T bean)
      throws Throwable
   {
      pool.destroyBean(bean);
   }
}
