package org.jboss.cache.loader;

import org.jboss.cache.config.CacheLoaderConfig;
import org.testng.annotations.Test;

/**
 * Odd that we need a test for a test class, but if we intend to use the {@link org.jboss.cache.loader.DummyInMemoryCacheLoader} as a cache
 * loader stub then we need to make sure it behaves as a valid cache loader.
 */
@Test(groups = {"functional"})
public class DummyInMemoryCacheLoaderTest extends CacheLoaderTestsBase
{
   protected void configureCache() throws Exception
   {
      // use the shared variation of the DIMCL so that state is persisted in a static variable in memory rather than an
      // instance one.
      CacheLoaderConfig clc = getSingleCacheLoaderConfig("", DummySharedInMemoryCacheLoader.class.getName(), "", false, true, false);
      cache.getConfiguration().setCacheLoaderConfig(clc);
   }
}
