package org.jboss.cache.notifications;

import org.jboss.cache.notifications.annotation.*;
import org.jboss.cache.notifications.event.Event;
import org.jboss.cache.notifications.event.EventImpl;

import java.util.ArrayList;
import java.util.List;

@CacheListener
public class EventLog
{
   public final List<Event> events = new ArrayList<Event>();

   @NodeCreated
   @NodeRemoved
   @NodeModified
   @NodeVisited
   @NodeMoved
   @TransactionCompleted
   @TransactionRegistered
   @NodeEvicted
   @NodePassivated
   @NodeActivated
   public void callback(Event e)
   {
      events.add(e);
   }

   public String toString()
   {
      return "EventLog{" +
            "events=" + events +
            '}';
   }

   /**
    * Done when we don't have a Transaction reference to compare with, e.g., when using implicit transactions in
    * opt locking.
    */
   public void scrubImplicitTransactions()
   {
      for (Event e : events) ((EventImpl) e).setTransaction(null);
   }
}