/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/

package org.jboss.tools.buildmagic.task.util;

import java.util.List;
import java.util.LinkedList;
import java.util.Iterator;

import org.apache.tools.ant.Task;

import org.jboss.tools.buildmagic.task.Tasks;

/**
 * A helper for creating tasks which can have one or more nested conditions.
 *
 * @version <pre>$Id: ConditionalExecution.java 21373 2008-08-05 19:10:51Z pgier $</pre>
 * @author  <a href="mailto:jason@planet57.com">Jason Dillon</a>
 */
public class ConditionalExecution
{
   protected List conditions = new LinkedList();
   protected Task task;

   public ConditionalExecution(final Task task) {
      this.task = task;
   }

   public Condition createCondition() {
      Condition cond = new Condition();
      conditions.add(cond);
      return cond;
   }

   public boolean canExecute() {
      Iterator iter = conditions.iterator();
      boolean can = true;
      while (iter.hasNext()) {
         Condition cond = (Condition)iter.next();
         if (!cond.canExecute())
            can = false;
      }

      return can;
   }
   
   public class Condition
   {
      protected String _if;
      protected String unless;

      public void setIf(String property) {
         _if = property;
      }

      public void setUnless(String property) {
         unless = property;
      }
   
      public boolean canExecute() {
         return Tasks.canExecute(task, _if, unless);
      }
   }
}
