/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/

package org.jboss.tools.buildmagic.task;

import org.apache.tools.ant.Task;

import org.jboss.tools.buildmagic.task.util.TaskLogger;

/**
 * Base class for other variable related tasks.
 *
 * @version <pre>$Id: VariableTask.java 21628 2008-08-19 22:06:02Z pgier $</pre>
 * @author  <a href="mailto:jason@planet57.com">Jason Dillon</a>
 */
public abstract class VariableTask
    extends Task
{
    /** Property variable. */
    public static final int PROPERTY = 0;

    /** User property variable. */
    public static final int USER_PROPERTY = 1;

    /** System property variable. */
    public static final int SYSTEM_PROPERTY = 2;

    /** Reference variable. */
    public static final int REFERENCE = 3;
    
    /** Instance logger. */
    protected final TaskLogger log = new TaskLogger(this);

    /** The name of the variable. */
    protected String name;

    /** The type of variable. */
    protected int type;

    /**
     * Set the name of the variable.
     */
    public void setName(final String name) {
        this.name = name;
    }
    
    /**
     * Set the type of the variable.
     */
    public void setType(String type) {
        type = type.toLowerCase();
        
        if (type.equals("prop") || type.equals("property")) {
            this.type = PROPERTY;
        }
        else if (type.equals("userprop") || type.equals("userproperty")) {
            this.type = USER_PROPERTY;
        }
        else if (type.equals("sysprop") || type.equals("systemproperty")) {
            this.type = SYSTEM_PROPERTY;
        }
        else if (type.equals("ref") || type.equals("reference")) {
            this.type = REFERENCE;
        }
        else {
            throw new IllegalAttributeException("type", this);
        }
    }
}
