/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/

package org.jboss.tools.buildmagic.task;

import java.io.*;
import java.util.*;

import org.apache.tools.ant.*;

import com.ibm.bsf.*;

/**
 * Execute a script.
 *
 * @version $Id: Script.java 21628 2008-08-19 22:06:02Z pgier $
 * @author  Jason Dillon <A href="mailto:jason@planet57.com">&lt;jason@planet57.com&gt;</A>
 */
public class Script 
   extends ScriptedTask 
{
   /** The script text to execute. */
   protected StringBuffer script = new StringBuffer();

   /**
    * Load the script from an external file.
    *
    * @param file    The file to load the source from.
    */
   public void setSrc(final File file) throws BuildException {
      log.verbose("reading script file: " + file);

      if (!file.exists())
         throw new BuildException("file not found: " + file);

      int count = (int)file.length();
      byte data[] = new byte[count];

      try {
         InputStream in = new BufferedInputStream(new FileInputStream(file));
         in.read(data);
         in.close();
      }
      catch (IOException e) {
         throw new BuildException(e);
      }
        
      script.append(new String(data));
   }

   /**
    * Add some lines to the script.
    *
    * @param test    A line of text to add to the script.
    */
   public void addText(final String text) {
      script.append(text);
   }

   /**
    * Execute the script.
    *
    * @param engine  The scripting engine.
    */
   protected void execute(final BSFEngine engine)
      throws BSFException, BuildException
   {
      // execute the script
      engine.exec("<SCRIPT>", 0, 0, script.toString());
   }
}

