/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/

package org.jboss.tools.buildmagic.task;

import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.BuildEvent;

/**
 * An abstract BuildListener.
 *
 * @version <pre>$Id: AbstractBuildListener.java 21373 2008-08-05 19:10:51Z pgier $</pre>
 * @author  <a href="mailto:jason@planet57.com">Jason Dillon</a>
 */
public abstract class AbstractBuildListener
   implements BuildListener
{
   /**
    *  Fired before any targets are started.
    */
   public void buildStarted(BuildEvent event) {
   }

   /**
    *  Fired after the last target has finished. This event
    *  will still be thrown if an error occured during the build.
    *
    *  @see BuildEvent#getException()
    */
   public void buildFinished(BuildEvent event) {
   }

   /**
    *  Fired when a target is started.
    *
    *  @see BuildEvent#getTarget()
    */
   public void targetStarted(BuildEvent event) {
   }

   /**
    *  Fired when a target has finished. This event will
    *  still be thrown if an error occured during the build.
    *
    *  @see BuildEvent#getException()
    */
   public void targetFinished(BuildEvent event) {
   }

   /**
    *  Fired when a task is started.
    *
    *  @see BuildEvent#getTask()
    */
   public void taskStarted(BuildEvent event) {
   }

   /**
    *  Fired when a task has finished. This event will still
    *  be throw if an error occured during the build.
    *
    *  @see BuildEvent#getException()
    */
   public void taskFinished(BuildEvent event) {
   }

   /**
    *  Fired whenever a message is logged.
    *
    *  @see BuildEvent#getMessage()
    *  @see BuildEvent#getPriority()
    */
   public void messageLogged(BuildEvent event) {
   }
}
