/*
 * Created on August 14 2003
 */
package org.workingfrog.i18n.util;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

import java.util.Properties;

/**
 * @author Jean-Hugues de Raigniac
 */
public class PropertiesLoader {

    private static Properties properties = new Properties();

    private static String logLevelKey = "i18n.log.level";
    private static String bundlesPathKey = "i18n.bundles.path";

    public static void init () {
        Properties defaults = new Properties();
        FileInputStream in;
        try {
            in = new FileInputStream("default.properties");
            defaults.load(in);
            in.close();
        } catch (FileNotFoundException e) {
            Translator.log(LogLevel.I18N, "default property file not found.");
        } catch (IOException e) {
            // there may not be a default.properties file
        }

        properties = new Properties(defaults);

        try {
            in = new FileInputStream("user.properties");
            properties.load(in);
            in.close();
        } catch (FileNotFoundException e) {
            Translator.log(LogLevel.I18N, "user property file not found.");
        } catch (IOException e) {
            // there may not be a default.properties file
        }

        if (properties.size() <= 0) {
            properties.setProperty(logLevelKey, "ALL");
        }
    }

    public static String getLogLevel () {
        String result = properties.getProperty(logLevelKey);
        return (result != null) ? result : "NONE";
    }

    public static void setLogLevel (LogLevel level) {
        properties.setProperty(logLevelKey, level.toString());
    }

    public static void setLogLevel (String level) {
        properties.setProperty(logLevelKey, level);
    }

    public static String getBundlesPath () {
        String result = properties.getProperty(bundlesPathKey);
        return (result != null) ? result : "";
    }

    public static void setBundlesPath (String path) {
        properties.setProperty(bundlesPathKey, path);
    }
}
