#!/bin/sh -e

# called by uscan with '--upstream-version' <version> <file>
SOURCE=$(dpkg-parsechangelog | sed -ne 's,Source: \(.*\),\1,p')
TAR=../${SOURCE}_$2.orig.tar.gz
DIR=${SOURCE}-$2.orig

# clean up the upstream tarball
unzip $3
mv hibernate-entitymanager-$2 $DIR
tar -c -z -f $TAR -X debian/orig-tar.exclude $DIR
rm -rf $3 $DIR

# move to directory 'tarballs'
if [ -r .svn/deb-layout ]; then
  . .svn/deb-layout
  mv $TAR $origDir
  echo "moved $TAR to $origDir"
fi

