// 
// Copyright (c) 2006-2008 Ben Motmans
// 
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.
//
// Author(s):
//    Ben Motmans <ben.motmans@gmail.com>
//

using System;
using System.Collections.Generic;

using Anculus.Core;

using NUnit.Framework;

namespace Anculus.UnitTests
{
	public class SearchTest
	{
		//random text from wikipedia
		public const string ShortText = "Trading habit is a behaviour exhibited by rodents (and more specifically, by pack rats) in which they will drop an item that they are currently carrying in favour of another, more attractive item. It is particularly pronounced in the Bushy-tailed Woodrat, which may incorporate a wide range of natural and manufactured items in its midden.";

		//random wikipedia article: http://en.wikipedia.org/wiki/Pacific_Locomotive_Association
		public const string MediumText = @"The PLA was formed by six people from the San Francisco Peninsula in 1961. Prompted to take action by the recent demise of mainline steam railroading, the PLA was established to promote passenger excursion trains featuring unique and unusual locations and equipment. They also hoped to preserve elements of the steam era for future generations.
Two of the PLA's first trips set the stage for the organization's early activities. The first of these was a May 1961 visit to the Howard Terminal Railway, and featured their last steam locomotive, No. 6. Shortly afterward, this steam engine was officially retired. Three of the founding members, then college students, purchased this engine for $250 from Peter and Harmon Howard, on the condition that 'the engine never be scrapped'. Thus No. 6 became the first artifact of railroad history to be preserved by the PLA.
A second field trip was held the following month. This trip featured the Blake Brothers rail operation on the shore of San Francisco Bay at Point Molate, near the eastern end of Richmond-San Rafael Bridge. Their two-truck Heisler locomotive was operated over the railroad after many years of storage, but only after the group dug out the rails which had been buried by years of quarry dust.
The formal organization of the Pacific Locomotive Association took place at Burlingame, California, in July, 1961. The original members were Charles Heimerdinger, Jr., Karl Koenig, Henry Luna, Thomas Eikrenkotter, Bart Gregg and Robert Field. Henry Luna was elected as the first president. As there were six charter members, and the first field trip featured engine No. 6, the present PLA logo is in the form of a locomotive's number plate with '6' in the center.
In 1962 two trips open to the public were sponsored over the California Western Railroad. The first was from Ft. Bragg to Willits and return in August, using the railroad's M200 'Skunk'. This trip sold out quickly, so it was repeated a month later. Round-trip fare, including coffee and donuts, was $6.35. The historic M200, built in 1926, was later purchased by PLA to save it from being scrapped, and now operates regularly on the Niles Canyon Railway.
In the mid 1990s a group of current and former Southern Pacific employees operating an organization known as 'Project 2467 Inc.' with the goal of restoring and maintaining former Southern Pacific steam locomotive number 2467 merged into the PLA.
The PLA news bulletin, sent to members each month, grew into a full-fledged railroad news magazine. Single issues and subscriptions to PLA's 'Pacific News'' were sold as a fund raiser. They were initially written, edited and produced by PLA volunteers on a Ditto machine, as demand increased it eventually became possible to use a professional printer. The magazine was eventually spun off and published independently. The name was later changed to ''Pacific Rail News'' and, with expanded coverage and national distribution, it was later shortened to its final name, ''Rail News.'' Although successful for many years the magazine was discontinued by Pentrex in the 1990s.
In 1965 two other steam locomotives became available for preservation. A donation by Connell Brothers Trucking of Stockton gave the PLA two additional steam locomotives; No. 5, a rare three-truck Heisler locomotive, and No. 12, the oldest standard gauge three-truck Shay locomotive known to exist.
By 1967, the previously mentioned Blake Brothers quarry railroad, then owned by Quarry Products, Inc., had ceased rail operations at Point Richmond. Originally known as the Castro Point Railway and Terminal Co., this railroad had been a joint operation with the Key System, which used the railroad for its streetcars to reach the Richmond-San Rafael Ferry terminal. Quarry Products leased the railroad to the PLA for one dollar per year.
As other historic locomotives and cars were acquired, they were moved to the Castro Point Railway. An agreement was reached in 1973 to use trackage in the adjoining Point Molate Naval Fuel Depot for a terminal where PLA's equipment could be stored and maintained.
Over the years, eleven steam locomotives and ten internal combustion locomotives, plus more than 35 passenger and freight cars, have been added to PLA's historic collection. Many of these were restored to active status and operated over the Castro Point Railway. This operating railroad museum began in 1969, and ran for the public until December, 1985, when the U.S. Navy, concerned about security, canceled the agreement.
As operations were coming to an end at Castro Point, the Southern Pacific Railroad was in the process of ending service on its line through Niles Canyon and over Altamont Pass, transferring its right-of-way to Alameda County after removal of the track. The County agreed to lease the Niles Canyon portion of the right-of-way to the PLA as a new home for the PLA’s collection and operations.
Volunteer PLA members began relaying the track with some rail donated by both the Southern Pacific and Union Pacific Railroad. The first section, between Sunol and Brightside, was opened using California Western ''Skunk'' M200 on May 21, 1988. Between 1988 and 1994, track laying through the Canyon continued to Vallejo Mill Park, just short of Niles. Rails were extended to downtown Niles on September 19, 1998. Today the PLA operates the NCRy, a seven-mile railroad through the well-preserved and scenic Niles Canyon, and tens of thousands of people visit the railroad annually. Track reconstruction presently continues to the east along the five miles of right-of-way available between Sunol and Pleasanton.";
			
		//some random Kanji from wikipedia
		public const string ShortUnicodeText = "休 忘 男 沈 酒";
		
		public const string MediumTextKeywordMid = "Connell Brothers Trucking";
		public const string MediumTextKeywordBegin = "San Francisco Peninsula";
		public const string MediumTextKeywordEnd = "Vallejo Mill Park";
		
		public static readonly string[] MediumTextSmallKeywordSet = new string[] {"Southern", "donated", "The"};
		public static readonly string[] MediumTextMediumKeywordSet = new string[] {
			"Southern", "donated", "The", "owned", "known", "as", "2467", "stage", "locomotives", "1965", "1967", "1962", "1990", ":)", ":-)", ":(", ":-(", ":p", ":D", ":o",
			"35", "plus", "not", "keyword", "Blake", "(T)", "(t)", "(A)", "(a)", "A", "trip", "second", "Trucking", "Stockton", "Point Richmond", "Point Molate Naval Fuel Depot",
			"AZERTY", "QWERTY", "San", "Fransisco", "1961", "1901", "1902", "1903", "1904", "1905", "1906", "1907", "1908", "1909", "1910", "1911", "1912", "1913", "1914",
			"1915", "1916", "1917", "1918", "1919", "1920", "1921", "1922", "1923", "1924", "1925", "1926", "1927", "1928", "1929", "1930"
		};
	}
}
