// 
// Copyright (c) 2006-2008 Ben Motmans
// 
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.
//
// Author(s):
//    Ben Motmans <ben.motmans@gmail.com>
//

using System;
using System.Collections.Generic;

using Anculus.Core;

using NUnit.Framework;

namespace Anculus.UnitTests
{
	[TestFixture]
	public class InsertRandomTest
	{
		[Test]
		public void InsertInEmptyArray ()
		{
			string[] arr = new string[] {};
			
			Insert.RandomInsert<string> (ref arr, "a");
			Insert.RandomInsert<string> (ref arr, "z");
			Insert.RandomInsert<string> (ref arr, "g");
			Insert.RandomInsert<string> (ref arr, "z");
			Insert.RandomInsert<string> (ref arr, "a");
		}
		
		[Test]
		public void InsertInArray ()
		{
			int[] arr = new int[] {1, 2, 3};
			
			Insert.RandomInsert<int> (ref arr, 4);
			Insert.RandomInsert<int> (ref arr, 5);
			Insert.RandomInsert<int> (ref arr, 6);
			Insert.RandomInsert<int> (ref arr, 7);
			Insert.RandomInsert<int> (ref arr, 8);
		}
	}
}
