// 
// Copyright (c) 2006-2008 Ben Motmans
// 
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.
//
// Author(s):
//    Ben Motmans <ben.motmans@gmail.com>
//

using System;
using System.Collections.Generic;

using Anculus.Core;

using NUnit.Framework;

namespace Anculus.UnitTests
{
	[TestFixture]
	public class CollectionPropertyComparerTest
	{
		private static Employee[] _employees;
		
		[SetUp]
		public void Setup ()
		{
			_employees = new Employee [] {
				new Employee (1, "Charles", 15000),
				new Employee (2, "Albert", 20000),
				new Employee (3, "Nikola", 10000)
			};
		}
		
		[Test]
		public void SortEmployeeByName ()
		{
			Sort.QuickSort (_employees, new EmployeeNameComparer ());
			
			Assert.AreEqual ("Albert", _employees[0].Name);
			Assert.AreEqual ("Charles", _employees[1].Name);
			Assert.AreEqual ("Nikola", _employees[2].Name);
		}
		
		[Test]
		public void SearchFirstEmployeeByName ()
		{
			Sort.QuickSort (_employees, new EmployeeNameComparer ());
			
			int index = Sort.BinarySearchIndex (_employees, new EmployeeNameComparer (), "Albert");
			Assert.AreEqual (0, index);
		}
		
		[Test]
		public void SearchMidEmployeeByName ()
		{
			Sort.QuickSort (_employees, new EmployeeNameComparer ());
			
			int index = Sort.BinarySearchIndex (_employees, new EmployeeNameComparer (), "Charles");
			Assert.AreEqual (1, index);
		}
		
		[Test]
		public void SearchLastEmployeeByName ()
		{
			Sort.QuickSort (_employees, new EmployeeNameComparer ());
			
			int index = Sort.BinarySearchIndex (_employees, new EmployeeNameComparer (), "Nikola");
			Assert.AreEqual (2, index);
		}
		
		[Test]
		public void SearchNonExistingEmployeeByName ()
		{
			Sort.QuickSort (_employees, new EmployeeNameComparer ());
			
			int index = Sort.BinarySearchIndex (_employees, new EmployeeNameComparer (), "Max");
			Assert.Less (index, 0);
		}
	}
}
