// 
// Copyright (c) 2006-2008 Ben Motmans
// 
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.
//
// Author(s):
//    Ben Motmans <ben.motmans@gmail.com>
//

using System;
using System.Collections.Generic;

namespace Anculus.Core
{
	public struct SearchResult : IEquatable<SearchResult>
	{
		private int index;
		private string match;
		
		private static SearchResult _empty = new SearchResult (-1, null);
		
		internal SearchResult (int index, string match)
		{
			this.index = index;
			this.match = match;
		}
		
		public int Index
		{
			get { return index; }
		}

		public int Length
		{
			get { return match.Length; }
		}

		public string Match
		{
			get { return match; }
		}
		
		public static SearchResult Empty
		{
			get { return _empty; }
		}
		
		public override bool Equals (object obj)
		{
			if (obj == null)
				return false;
			
			SearchResult sr = (SearchResult)obj;
			return index == sr.index && match == sr.match;
		}
		
		public bool Equals (SearchResult other)
		{
			return index == other.index && match == other.match;
		}
		
		public override int GetHashCode ()
		{
			return index.GetHashCode () ^ match.GetHashCode ();
		}

		public static bool operator == (SearchResult sr1, SearchResult sr2)
		{
			return sr1.index == sr2.index && sr1.match == sr2.match;
		}
		
		public static bool operator != (SearchResult sr1, SearchResult sr2)
		{
			return sr1.index != sr2.index || sr1.match != sr2.match;
		}
	}
	
	public sealed class SearchResultComparer : IPropertyComparer<SearchResult, int>, IComparer<SearchResult>
	{
		public int Compare (SearchResult sr, int index)
		{
			return sr.Index.CompareTo (index);
		}
		
		public int Compare (SearchResult sr1, SearchResult sr2)
		{
			return sr1.Index.CompareTo (sr2.Index);
		}
	}
}
