// 
// Copyright (c) 2006-2008 Ben Motmans
// 
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.
//
// Author(s):
//    Ben Motmans <ben.motmans@gmail.com>
//

using System;
using System.Reflection;
using System.Diagnostics;

namespace Anculus.Core
{
	public static class Search
	{
		private static BoyerMooreSearchAlgorithm _boyerMoore;
		private static IndexOfSearchAlgorithm _indexOf;
		
		public static int[] SearchAll (string text, string keyword)
		{
			if (_boyerMoore == null)
				_boyerMoore = new BoyerMooreSearchAlgorithm ();
			
			return _boyerMoore.SearchAll (text, 0, int.MaxValue, keyword);
		}
		
		public static int[] SearchAll (string text, int start, string keyword)
		{
			if (_boyerMoore == null)
				_boyerMoore = new BoyerMooreSearchAlgorithm ();
			
			return _boyerMoore.SearchAll (text, start, int.MaxValue, keyword);
		}
		
		public static int[] SearchAll (string text, int start, int count, string keyword)
		{
			if (_boyerMoore == null)
				_boyerMoore = new BoyerMooreSearchAlgorithm ();
			
			return _boyerMoore.SearchAll (text, start, count, keyword);
		}

		public static int SearchFirst (string text, string keyword)
		{
			if (_indexOf == null)
				_indexOf = new IndexOfSearchAlgorithm ();
			
			return _indexOf.SearchFirst (text, 0, keyword);
		}
		
		public static int SearchFirst (string text, int start, string keyword)
		{
			if (_indexOf == null)
				_indexOf = new IndexOfSearchAlgorithm ();
			
			return _indexOf.SearchFirst (text, start, keyword);
		}

		public static bool Contains (string text, string keyword)
		{
			if (_indexOf == null)
				_indexOf = new IndexOfSearchAlgorithm ();
			
			return _indexOf.Contains (text, 0, keyword);
		}

		public static bool Contains (string text, int start, string keyword)
		{
			if (_indexOf == null)
				_indexOf = new IndexOfSearchAlgorithm ();
			
			return _indexOf.Contains (text, start, keyword);
		}
	}
}