package aQute.bnd.main.compiler;

import java.io.*;
import java.util.*;

import aQute.lib.osgi.*;

public class BndCompiler extends Processor {
	File[]	classpath;
	File[]	sourcepath;
	File	bin;
	String	targetLevel;
	String	sourceLevel;
	boolean debug;
	String cwd = new File("").getAbsolutePath();
	
	public static boolean isAvailable() {
		try {
			BndCompiler.class.getClassLoader().loadClass("org.eclipse.jdt.internal.compiler.batch.Main" );
			return true;
		} catch(ClassNotFoundException t ) {
			return false;
		}
	}

	public void setDebug(boolean debug) {
		this.debug = debug;
	}
	public void setClasspath(File[] classpath) {
		this.classpath = classpath;
	}

	public void setSourcepath(File[] sourcepath) {
		this.sourcepath = sourcepath;
	}

	public void setTargetLevel(String targetLevel) {
		this.targetLevel = targetLevel;
	}

	public void setSourceLevel(String sourceLevel) {
		this.sourceLevel = sourceLevel;
	}

	public void setBin(File bin) {
		this.bin = bin;
	}

	public void compile() throws Exception {
		StringBuffer sb = new StringBuffer();
		sb.append("-classpath ");
		explode(sb,classpath,File.pathSeparator);
		sb.append(File.pathSeparator + System.getProperty("java.class.path"));
		sb.append(" -sourcepath ");
		explode(sb, sourcepath,File.pathSeparator);
		sb.append(" -target ");
		sb.append(targetLevel);
		sb.append(" -source ");
		sb.append(sourceLevel);
		sb.append(" -d " );
		sb.append(bin.getAbsolutePath());
		sb.append(" -g ");
		
		for ( int i=0; i<sourcepath.length; i++  ) {
			File dir = sourcepath[i];
			List l = new ArrayList();
			expand(l,dir);
			for( Iterator sub=l.iterator(); sub.hasNext(); ) {
				File f = (File) sub.next();
				String path = getShortPath(f);
				
				sb.append(" ");
				sb.append(path);
			}
		}
		StringWriter errors = new StringWriter();
		StringWriter warnings = new StringWriter();
		System.out.println("Compile: " + sb.toString());
		org.eclipse.jdt.internal.compiler.batch.Main.compile(sb.toString(), new PrintWriter(errors), new PrintWriter(warnings));
		addToList(getErrors(), errors.getBuffer());
		addToList(getWarnings(), warnings.getBuffer());
	}

	private void expand(List l, File dir) {
		File subs[] = dir.listFiles();
		for(int i=0; i<subs.length; i++ ){
			if ( subs[i].isDirectory() ) {
				expand(l,subs[i]);
			} else {
				if ( subs[i].getName().endsWith(".java"))
					l.add(subs[i]);
			}
		}
	}

	private void addToList(List list, StringBuffer buffer) throws IOException {
		BufferedReader rdr = new BufferedReader( new StringReader(buffer.toString()));
		String line = rdr.readLine();
		while ( line != null ) {
			list.add(line);
		}
	}

	private void explode(StringBuffer sb, File[] classpath, String separator) {
		String del = "";
		for(int i =0; i<classpath.length; i++ ) {
			sb.append(del);
			sb.append(getShortPath(classpath[i]));
			del = separator;
		}
	}

	private String getShortPath(File file) {
		String path = file.getAbsolutePath();
		if ( path.startsWith(cwd))
			path = path.substring(cwd.length());
		return path;
	}

}
