/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.retroweaver.runtime.java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;

public class Collections_ {
    private Collections_() {
    }

    public static Collection checkedCollection(Collection c, Class type) {
        return new CheckedCollection(c, type);
    }

    public static Set checkedSet(Set s, Class type) {
        return new CheckedSet(s, type);
    }

    public static SortedSet checkedSortedSet(SortedSet s, Class type) {
        return new CheckedSortedSet(s, type);
    }

    public static List checkedList(List l, Class type) {
        return new CheckedList(l, type);
    }

    public static Map checkedMap(Map m, Class keyType, Class valueType) {
        return new CheckedMap(m, keyType, valueType);
    }

    public static SortedMap checkedSortedMap(SortedMap m, Class keyType, Class valueType) {
        return new CheckedSortedMap(m, keyType, valueType);
    }

    public static Set emptySet() {
        return Collections.EMPTY_SET;
    }

    public static List emptyList() {
        return Collections.EMPTY_LIST;
    }

    public static Map emptyMap() {
        return Collections.EMPTY_MAP;
    }

    public static Comparator reverseOrder(Comparator cmp) {
        return cmp instanceof ReverseComparator ? ((ReverseComparator)cmp).cmp : (cmp == null ? Collections.reverseOrder() : new ReverseComparator(cmp));
    }

    public static int frequency(Collection c, Object o) {
        int freq = 0;
        if (o == null) {
            Iterator itr = c.iterator();
            while (itr.hasNext()) {
                if (itr.next() != null) continue;
                ++freq;
            }
        } else {
            Iterator itr = c.iterator();
            while (itr.hasNext()) {
                if (!o.equals(itr.next())) continue;
                ++freq;
            }
        }
        return freq;
    }

    public static boolean disjoint(Collection a, Collection b) {
        if (a instanceof Set && (!(b instanceof Set) || a.size() < b.size())) {
            Collection tmp = a;
            a = b;
            b = tmp;
        }
        Iterator itr = a.iterator();
        while (itr.hasNext()) {
            if (!b.contains(itr.next())) continue;
            return false;
        }
        return true;
    }

    public static boolean addAll(Collection c, Object[] a) {
        boolean modified = false;
        for (int i = 0; i < a.length; ++i) {
            modified |= c.add(a[i]);
        }
        return modified;
    }

    private static boolean eq(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    private static class ReverseComparator
    implements Comparator,
    Serializable {
        final Comparator cmp;

        ReverseComparator(Comparator cmp) {
            this.cmp = cmp;
        }

        public int compare(Object o1, Object o2) {
            return this.cmp.compare(o2, o1);
        }
    }

    private static class SetFromMap
    extends AbstractSet
    implements Serializable {
        private static final Object PRESENT = Boolean.TRUE;
        final Map map;
        transient Set keySet;

        SetFromMap(Map map) {
            this.map = map;
            this.keySet = map.keySet();
        }

        public int hashCode() {
            return ((Object)this.keySet).hashCode();
        }

        public int size() {
            return this.map.size();
        }

        public void clear() {
            this.map.clear();
        }

        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        public boolean add(Object o) {
            return this.map.put(o, PRESENT) == null;
        }

        public boolean contains(Object o) {
            return this.map.containsKey(o);
        }

        public boolean equals(Object o) {
            return o == this || ((Object)this.keySet).equals(o);
        }

        public boolean remove(Object o) {
            return this.map.remove(o) == PRESENT;
        }

        public boolean removeAll(Collection c) {
            return this.keySet.removeAll(c);
        }

        public boolean retainAll(Collection c) {
            return this.keySet.retainAll(c);
        }

        public Iterator iterator() {
            return this.keySet.iterator();
        }

        public Object[] toArray() {
            return this.keySet.toArray();
        }

        public Object[] toArray(Object[] a) {
            return this.keySet.toArray(a);
        }

        public boolean addAll(Collection c) {
            boolean modified = false;
            Iterator it = c.iterator();
            while (it.hasNext()) {
                modified |= this.map.put(it.next(), PRESENT) == null;
            }
            return modified;
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            this.keySet = this.map.keySet();
        }
    }

    private static class CheckedSortedMap
    extends CheckedMap
    implements SortedMap {
        final SortedMap map;

        CheckedSortedMap(SortedMap map, Class keyType, Class valueType) {
            super(map, keyType, valueType);
            this.map = map;
        }

        public Comparator comparator() {
            return this.map.comparator();
        }

        public Object firstKey() {
            return this.map.firstKey();
        }

        public Object lastKey() {
            return this.map.lastKey();
        }

        public SortedMap subMap(Object fromKey, Object toKey) {
            return new CheckedSortedMap(this.map.subMap(fromKey, toKey), this.keyType, this.valueType);
        }

        public SortedMap headMap(Object toKey) {
            return new CheckedSortedMap(this.map.headMap(toKey), this.keyType, this.valueType);
        }

        public SortedMap tailMap(Object fromKey) {
            return new CheckedSortedMap(this.map.tailMap(fromKey), this.keyType, this.valueType);
        }
    }

    private static class CheckedMap
    implements Map,
    Serializable {
        final Map map;
        final Class keyType;
        final Class valueType;
        transient Set entrySet;
        private transient Object[] emptyKeyArray;
        private transient Object[] emptyValueArray;

        CheckedMap(Map map, Class keyType, Class valueType) {
            if (map == null || keyType == null || valueType == null) {
                throw new NullPointerException();
            }
            this.map = map;
            this.keyType = keyType;
            this.valueType = valueType;
        }

        private void typeCheckKey(Object key) {
            if (!this.keyType.isInstance(key)) {
                throw new ClassCastException("Attempted to use a key of type " + key.getClass().getName() + " with a map with keys of type " + this.keyType.getName());
            }
        }

        private void typeCheckValue(Object value) {
            if (!this.valueType.isInstance(value)) {
                throw new ClassCastException("Attempted to use a value of type " + value.getClass().getName() + " with a map with values of type " + this.valueType.getName());
            }
        }

        public int hashCode() {
            return ((Object)this.map).hashCode();
        }

        public boolean equals(Object o) {
            return o == this || ((Object)this.map).equals(o);
        }

        public int size() {
            return this.map.size();
        }

        public void clear() {
            this.map.clear();
        }

        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        public boolean containsKey(Object key) {
            return this.map.containsKey(key);
        }

        public boolean containsValue(Object value) {
            return this.map.containsValue(value);
        }

        public Collection values() {
            return this.map.values();
        }

        public Set keySet() {
            return this.map.keySet();
        }

        public void putAll(Map m) {
            Object[] values;
            Object[] keys;
            if (this.emptyKeyArray == null) {
                this.emptyKeyArray = (Object[])Array.newInstance(this.keyType, 0);
            }
            if (this.emptyValueArray == null) {
                this.emptyValueArray = (Object[])Array.newInstance(this.valueType, 0);
            }
            try {
                keys = m.keySet().toArray(this.emptyKeyArray);
            }
            catch (ArrayStoreException e) {
                throw new ClassCastException("Attempted to use an invalid key type  with a map with keys of type " + this.keyType.getName());
            }
            try {
                values = m.keySet().toArray(this.emptyKeyArray);
            }
            catch (ArrayStoreException e) {
                throw new ClassCastException("Attempted to use an invalid value type  with a map with values of type " + this.valueType.getName());
            }
            if (keys.length != values.length) {
                throw new ConcurrentModificationException();
            }
            for (int i = 0; i < keys.length; ++i) {
                this.map.put(keys[i], values[i]);
            }
        }

        public Set entrySet() {
            if (this.entrySet == null) {
                this.entrySet = new EntrySetView(this.map.entrySet());
            }
            return this.entrySet;
        }

        public Object get(Object key) {
            return this.map.get(key);
        }

        public Object remove(Object key) {
            return this.map.remove(key);
        }

        public Object put(Object key, Object value) {
            this.typeCheckKey(key);
            this.typeCheckValue(value);
            return this.map.put(key, value);
        }

        private class EntryView
        implements Map.Entry,
        Serializable {
            final Map.Entry entry;

            EntryView(Map.Entry entry) {
                this.entry = entry;
            }

            public Object getKey() {
                return this.entry.getKey();
            }

            public Object getValue() {
                return this.entry.getValue();
            }

            public int hashCode() {
                return ((Object)this.entry).hashCode();
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry e = (Map.Entry)o;
                return Collections_.eq(this.getKey(), e.getKey()) && Collections_.eq(this.getValue(), e.getValue());
            }

            public Object setValue(Object val) {
                CheckedMap.this.typeCheckValue(val);
                return this.entry.setValue(val);
            }
        }

        private class EntrySetView
        extends AbstractSet
        implements Set {
            final Set entrySet;
            private static final /* synthetic */ Class class$net$sourceforge$retroweaver$runtime$java$util$Collections_$CheckedMap$EntryView;

            EntrySetView(Set entrySet) {
                this.entrySet = entrySet;
            }

            public int size() {
                return this.entrySet.size();
            }

            public boolean isEmpty() {
                return this.entrySet.isEmpty();
            }

            public boolean remove(Object o) {
                return this.entrySet.remove(o);
            }

            public void clear() {
                this.entrySet.clear();
            }

            public boolean contains(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                return this.entrySet.contains(new EntryView((Map.Entry)o));
            }

            public Iterator iterator() {
                final Iterator itr = this.entrySet.iterator();
                return new Iterator(){

                    public boolean hasNext() {
                        return itr.hasNext();
                    }

                    public Object next() {
                        return new EntryView((Map.Entry)itr.next());
                    }

                    public void remove() {
                        itr.remove();
                    }
                };
            }

            public Object[] toArray() {
                Object[] a = this.entrySet.toArray();
                Class<?> clazz = a.getClass().getComponentType();
                Class<?> clazz2 = class$net$sourceforge$retroweaver$runtime$java$util$Collections_$CheckedMap$EntryView;
                if (clazz2 == null) {
                    clazz2 = class$net$sourceforge$retroweaver$runtime$java$util$Collections_$CheckedMap$EntryView = new EntryView[0].getClass().getComponentType();
                }
                if (clazz.isAssignableFrom(clazz2)) {
                    for (int i = 0; i < a.length; ++i) {
                        a[i] = new EntryView((Map.Entry)a[i]);
                    }
                    return a;
                }
                Object[] newa = new Object[a.length];
                for (int i = 0; i < a.length; ++i) {
                    newa[i] = new EntryView((Map.Entry)a[i]);
                }
                return newa;
            }

            public Object[] toArray(Object[] a) {
                Object[] base = a.length == 0 ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), a.length);
                base = this.entrySet.toArray(base);
                for (int i = 0; i < base.length; ++i) {
                    base[i] = new EntryView((Map.Entry)base[i]);
                }
                if (base.length > a.length) {
                    a = base;
                } else {
                    System.arraycopy(base, 0, a, 0, base.length);
                    if (base.length < a.length) {
                        a[base.length] = null;
                    }
                }
                return a;
            }
        }
    }

    private static class CheckedSortedSet
    extends CheckedSet
    implements SortedSet,
    Serializable {
        final SortedSet set;

        CheckedSortedSet(SortedSet set, Class type) {
            super(set, type);
            this.set = set;
        }

        public Object first() {
            return this.set.first();
        }

        public Object last() {
            return this.set.last();
        }

        public Comparator comparator() {
            return this.set.comparator();
        }

        public SortedSet headSet(Object toElement) {
            return new CheckedSortedSet(this.set.headSet(toElement), this.type);
        }

        public SortedSet tailSet(Object fromElement) {
            return new CheckedSortedSet(this.set.tailSet(fromElement), this.type);
        }

        public SortedSet subSet(Object fromElement, Object toElement) {
            return new CheckedSortedSet(this.set.subSet(fromElement, toElement), this.type);
        }
    }

    private static class CheckedSet
    extends CheckedCollection
    implements Set,
    Serializable {
        CheckedSet(Set set, Class type) {
            super(set, type);
        }

        public int hashCode() {
            return ((Object)this.coll).hashCode();
        }

        public boolean equals(Object o) {
            return o == this || ((Object)this.coll).equals(o);
        }
    }

    private static class CheckedList
    extends CheckedCollection
    implements List,
    Serializable {
        final List list;

        CheckedList(List list, Class type) {
            super(list, type);
            this.list = list;
        }

        public Object get(int index) {
            return this.list.get(index);
        }

        public Object remove(int index) {
            return this.list.remove(index);
        }

        public int indexOf(Object o) {
            return this.list.indexOf(o);
        }

        public int lastIndexOf(Object o) {
            return this.list.lastIndexOf(o);
        }

        public int hashCode() {
            return ((Object)this.list).hashCode();
        }

        public boolean equals(Object o) {
            return o == this || ((Object)this.list).equals(o);
        }

        public Object set(int index, Object element) {
            this.typeCheck(element);
            return this.list.set(index, element);
        }

        public void add(int index, Object element) {
            this.typeCheck(element);
            this.list.add(index, element);
        }

        public boolean addAll(int index, Collection c) {
            Object[] checked;
            try {
                checked = c.toArray(this.getEmptyArr());
            }
            catch (ArrayStoreException e) {
                throw new ClassCastException("Attempted to insert an element of invalid type  to a list of type " + this.type.getName());
            }
            return this.list.addAll(index, Arrays.asList(checked));
        }

        public List subList(int fromIndex, int toIndex) {
            return new CheckedList(this.list.subList(fromIndex, toIndex), this.type);
        }

        public ListIterator listIterator() {
            return new ListItr(this.list.listIterator());
        }

        public ListIterator listIterator(int index) {
            return new ListItr(this.list.listIterator(index));
        }

        private class ListItr
        implements ListIterator {
            final ListIterator itr;

            ListItr(ListIterator itr) {
                this.itr = itr;
            }

            public boolean hasNext() {
                return this.itr.hasNext();
            }

            public boolean hasPrevious() {
                return this.itr.hasPrevious();
            }

            public int nextIndex() {
                return this.itr.nextIndex();
            }

            public int previousIndex() {
                return this.itr.previousIndex();
            }

            public Object next() {
                return this.itr.next();
            }

            public Object previous() {
                return this.itr.previous();
            }

            public void remove() {
                this.itr.remove();
            }

            public void set(Object element) {
                CheckedList.this.typeCheck(element);
                this.itr.set(element);
            }

            public void add(Object element) {
                CheckedList.this.typeCheck(element);
                this.itr.add(element);
            }
        }
    }

    private static class CheckedCollection
    implements Collection,
    Serializable {
        final Collection coll;
        final Class type;
        transient Object[] emptyArr;

        CheckedCollection(Collection coll, Class type) {
            if (coll == null || type == null) {
                throw new NullPointerException();
            }
            this.coll = coll;
            this.type = type;
        }

        void typeCheck(Object obj) {
            if (!this.type.isInstance(obj)) {
                throw new ClassCastException("Attempted to insert an element of type " + obj.getClass().getName() + " to a collection of type " + this.type.getName());
            }
        }

        public int size() {
            return this.coll.size();
        }

        public void clear() {
            this.coll.clear();
        }

        public boolean isEmpty() {
            return this.coll.isEmpty();
        }

        public Object[] toArray() {
            return this.coll.toArray();
        }

        public Object[] toArray(Object[] a) {
            return this.coll.toArray(a);
        }

        public boolean contains(Object o) {
            return this.coll.contains(o);
        }

        public boolean remove(Object o) {
            return this.coll.remove(o);
        }

        public boolean containsAll(Collection c) {
            return this.coll.containsAll(c);
        }

        public boolean removeAll(Collection c) {
            return this.coll.removeAll(c);
        }

        public boolean retainAll(Collection c) {
            return this.coll.retainAll(c);
        }

        public String toString() {
            return this.coll.toString();
        }

        public boolean add(Object o) {
            this.typeCheck(o);
            return this.coll.add(o);
        }

        public boolean addAll(Collection c) {
            Object[] checked;
            try {
                checked = c.toArray(this.getEmptyArr());
            }
            catch (ArrayStoreException e) {
                throw new ClassCastException("Attempted to insert an element of invalid type  to a collection of type " + this.type.getName());
            }
            return this.coll.addAll(Arrays.asList(checked));
        }

        public Iterator iterator() {
            return new Itr(this.coll.iterator());
        }

        protected Object[] getEmptyArr() {
            if (this.emptyArr == null) {
                this.emptyArr = (Object[])Array.newInstance(this.type, 0);
            }
            return this.emptyArr;
        }

        class Itr
        implements Iterator {
            final Iterator itr;

            Itr(Iterator itr) {
                this.itr = itr;
            }

            public boolean hasNext() {
                return this.itr.hasNext();
            }

            public Object next() {
                return this.itr.next();
            }

            public void remove() {
                this.itr.remove();
            }
        }
    }
}

