/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.retroweaver;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.sourceforge.retroweaver.LazyException;
import net.sourceforge.retroweaver.RetroWeaverAttribute;
import net.sourceforge.retroweaver.Weaver;
import net.sourceforge.retroweaver.event.WeaveListener;
import net.sourceforge.retroweaver.translator.NameTranslator;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodAdapter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;

class ClassWeaver
extends ClassAdapter
implements Opcodes {
    private final boolean lazy;
    private final boolean stripAttributes;
    private final int target;
    private int originalClassVersion;
    private final WeaveListener listener;
    private String className;
    private boolean isEnum;
    private boolean isInterface;
    private final Set<String> classLiteralCalls = new HashSet<String>();
    private static final String JAVA_LANG_CLASS = "java/lang/Class";
    private static final String JAVA_LANG_OBJECT = "java/lang/Object";
    private static final String GET_CLASS_METHOD = "getClass";
    private static final String GET_CLASS_SIGNATURE = "()Ljava/lang/Class;";
    private static final String GET_COMPONENT_TYPE_METHOD = "getComponentType";
    private static final String GET_COMPONENT_TYPE_SIGNATURE = "()Ljava/lang/Class;";
    private static final String SERIAL_ID_FIELD = "serialVersionUID";
    private static final String SERIAL_ID_SIGNATURE = "J";
    private static final String CLASS_FIELD_DESC = "Ljava/lang/Class;";
    private static final String ITERABLE_CLASS = "java/lang/Iterable";
    private static final String ITERATOR_METHOD = "iterator";
    private static final String ITERATOR_SIGNATURE = "()Ljava/util/Iterator;";
    private static final String ITERABLE_METHODS_CLASS = "net/sourceforge/retroweaver/runtime/java/lang/Iterable_";
    private static final String ITERABLE_METHODS_ITERATOR_SIGNATURE = "(Ljava/lang/Object;)Ljava/util/Iterator;";
    private static final String APPEND_METHOD = "append";
    private static final String APPENDABLE_APPEND_SIGNATURE1 = "(C)Ljava/lang/Appendable;";
    private static final String APPENDABLE_APPEND_SIGNATURE2 = "(Ljava/lang/CharSequence;II)Ljava/lang/Appendable;";
    private static final String APPENDABLE_APPEND_SIGNATURE3 = "(Ljava/lang/CharSequence;)Ljava/lang/Appendable;";
    private static final String RETROWEAVER_ENUM = "net/sourceforge/retroweaver/runtime/java/lang/Enum";
    private static final String REENTRANTREADWRITELOCK_CLASS = "java/util/concurrent/locks/ReentrantReadWriteLock";
    private static final String REENTRANTREADWRITELOCK_READLOCK_CLASS = "java/util/concurrent/locks/ReentrantReadWriteLock$ReadLock";
    private static final String REENTRANTREADWRITELOCK_WRITELOCK_CLASS = "java/util/concurrent/locks/ReentrantReadWriteLock$WriteLock";
    private static final String READLOCK_METHOD = "readLock";
    private static final String WRITELOCK_METHOD = "writeLock";
    private static final String REENTRANTREADWRITELOCK_READLOCK_SIGNATURE = "()Ljava/util/concurrent/locks/ReentrantReadWriteLock$ReadLock;";
    private static final String REENTRANTREADWRITELOCK_WRITELOCK_SIGNATURE = "()Ljava/util/concurrent/locks/ReentrantReadWriteLock$WriteLock;";
    private static final String REENTRANTREADWRITELOCK_READLOCK_NEW_SIGNATURE = "()Ljava/util/concurrent/locks/Lock;";
    private static final String REENTRANTREADWRITELOCK_WRITELOCK_NEW_SIGNATURE = "()Ljava/util/concurrent/locks/Lock;";

    public ClassWeaver(ClassVisitor cv, boolean lazy, boolean stripAttributes, int target, WeaveListener listener) {
        super(cv);
        this.lazy = lazy;
        this.stripAttributes = stripAttributes;
        this.target = target;
        this.listener = listener;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        if (this.lazy && version <= this.target) {
            throw new LazyException();
        }
        if (this.listener != null) {
            this.listener.weavingPath(name);
        }
        this.className = name;
        this.isEnum = superName != null && superName.equals("java/lang/Enum");
        this.isInterface = (access & 0x200) == 512;
        this.originalClassVersion = version;
        this.cv.visit(this.target, access, name, signature, superName, interfaces);
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        this.cv.visitInnerClass(name, outerName, innerName, access);
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        return this.cv.visitField(access, name, desc, signature, value);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        String[] newExceptions;
        int newAccess;
        if ((access & 0x1040) == 4160) {
            newAccess = access;
            if (name.equals(APPEND_METHOD) && (desc.equals(APPENDABLE_APPEND_SIGNATURE1) || desc.equals(APPENDABLE_APPEND_SIGNATURE2) || desc.equals(APPENDABLE_APPEND_SIGNATURE3))) {
                return null;
            }
        } else {
            newAccess = access;
        }
        if (exceptions != null) {
            newExceptions = new String[exceptions.length];
            for (int i = 0; i < exceptions.length; ++i) {
                newExceptions[i] = NameTranslator.getGeneralTranslator().getClassMirrorTranslation(exceptions[i]);
            }
        } else {
            newExceptions = exceptions;
        }
        MethodWeaver mv = new MethodWeaver(super.visitMethod(newAccess, name, desc, signature, newExceptions));
        if (!this.isEnum || !"<clinit>".equals(name)) {
            return mv;
        }
        return new EnumMethodWeaver((MethodVisitor)mv);
    }

    public void visitAttribute(Attribute attr) {
        if (attr instanceof RetroWeaverAttribute) {
            RetroWeaverAttribute ra = (RetroWeaverAttribute)attr;
            this.originalClassVersion = ra.getOriginalClassVersion();
        } else {
            this.cv.visitAttribute(attr);
        }
    }

    public void visitEnd() {
        if (this.isEnum) {
            this.cv.visitField(4122, SERIAL_ID_FIELD, SERIAL_ID_SIGNATURE, null, (Object)new Long(0L));
        }
        if (!this.classLiteralCalls.isEmpty()) {
            Iterator<String> i$ = this.classLiteralCalls.iterator();
            while (i$.hasNext()) {
                String fieldName = i$.next();
                FieldVisitor fv = this.visitField(4120 + (this.isInterface ? 1 : 2), fieldName, CLASS_FIELD_DESC, null, null);
                fv.visitEnd();
            }
        }
        if (!this.stripAttributes) {
            RetroWeaverAttribute a = new RetroWeaverAttribute(Weaver.getBuildNumber(), this.originalClassVersion);
            this.cv.visitAttribute((Attribute)a);
        }
        this.cv.visitEnd();
    }

    private void generateClassCall(MethodVisitor mv, String cls) {
        mv.visitInsn(3);
        mv.visitTypeInsn(189, cls);
        mv.visitMethodInsn(182, JAVA_LANG_OBJECT, GET_CLASS_METHOD, "()Ljava/lang/Class;");
        mv.visitMethodInsn(182, JAVA_LANG_CLASS, GET_COMPONENT_TYPE_METHOD, "()Ljava/lang/Class;");
    }

    class MethodWeaver
    extends MethodAdapter
    implements Opcodes {
        public MethodWeaver(MethodVisitor mv) {
            super(mv);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            if (opcode == 185 && owner.equals(ClassWeaver.ITERABLE_CLASS) && name.equals(ClassWeaver.ITERATOR_METHOD) && desc.equals(ClassWeaver.ITERATOR_SIGNATURE)) {
                super.visitMethodInsn(184, ClassWeaver.ITERABLE_METHODS_CLASS, ClassWeaver.ITERATOR_METHOD, ClassWeaver.ITERABLE_METHODS_ITERATOR_SIGNATURE);
                return;
            }
            if (opcode == 182 && owner.equals(ClassWeaver.REENTRANTREADWRITELOCK_CLASS)) {
                if (name.equals(ClassWeaver.READLOCK_METHOD) && desc.equals(ClassWeaver.REENTRANTREADWRITELOCK_READLOCK_SIGNATURE)) {
                    super.visitMethodInsn(opcode, owner, name, "()Ljava/util/concurrent/locks/Lock;");
                    super.visitTypeInsn(192, ClassWeaver.REENTRANTREADWRITELOCK_READLOCK_CLASS);
                    return;
                }
                if (name.equals(ClassWeaver.WRITELOCK_METHOD) && desc.equals(ClassWeaver.REENTRANTREADWRITELOCK_WRITELOCK_SIGNATURE)) {
                    super.visitMethodInsn(opcode, owner, name, "()Ljava/util/concurrent/locks/Lock;");
                    super.visitTypeInsn(192, ClassWeaver.REENTRANTREADWRITELOCK_WRITELOCK_CLASS);
                    return;
                }
            }
            super.visitMethodInsn(opcode, owner, name, desc);
        }

        public void visitLdcInsn(Object cst) {
            if (cst instanceof Type) {
                Type t = (Type)cst;
                String fieldName = this.getClassLiteralFieldName(t);
                ClassWeaver.this.classLiteralCalls.add(fieldName);
                this.mv.visitFieldInsn(178, ClassWeaver.this.className, fieldName, ClassWeaver.CLASS_FIELD_DESC);
                this.mv.visitInsn(89);
                Label nonNullLabel = new Label();
                this.mv.visitJumpInsn(199, nonNullLabel);
                this.mv.visitInsn(87);
                String s = t.getSort() == 10 ? t.getInternalName() : t.getDescriptor();
                s = NameTranslator.getGeneralTranslator().getClassMirrorTranslationDescriptor(s);
                s = NameTranslator.getStringBuilderTranslator().getClassMirrorTranslationDescriptor(s);
                s = NameTranslator.getHarmonyTranslator().getClassMirrorTranslationDescriptor(s);
                ClassWeaver.this.generateClassCall(this.mv, s);
                this.mv.visitInsn(89);
                this.mv.visitFieldInsn(179, ClassWeaver.this.className, fieldName, ClassWeaver.CLASS_FIELD_DESC);
                this.mv.visitLabel(nonNullLabel);
            } else {
                super.visitLdcInsn(cst);
            }
        }

        private String getClassLiteralFieldName(Type type) {
            String fieldName;
            if (type.getSort() == 9) {
                fieldName = "array" + type.getDescriptor().replace('[', '$');
                if (fieldName.charAt(fieldName.length() - 1) == ';') {
                    fieldName = fieldName.substring(0, fieldName.length() - 1);
                }
            } else {
                fieldName = "class$" + type.getInternalName();
            }
            fieldName = fieldName.replace('/', '$');
            return fieldName;
        }
    }

    private class EnumMethodWeaver
    extends MethodAdapter
    implements Opcodes {
        public EnumMethodWeaver(MethodVisitor mv) {
            super(mv);
        }

        public void visitInsn(int opcode) {
            if (opcode == 177) {
                String owner = ClassWeaver.this.className.replace('.', '/');
                String fullName = 'L' + owner + ';';
                Type t = Type.getType((String)fullName);
                this.mv.visitMethodInsn(184, owner, "values", "()[" + fullName);
                this.mv.visitLdcInsn((Object)t);
                this.mv.visitMethodInsn(184, ClassWeaver.RETROWEAVER_ENUM, "setEnumValues", "([Ljava/lang/Object;Ljava/lang/Class;)V");
            }
            this.mv.visitInsn(opcode);
        }
    }
}

