/*
 * Decompiled with CFR 0.152.
 */
package org.dynalang.mop.beans;

import java.beans.IntrospectionException;
import java.lang.reflect.Array;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.dynalang.mop.BaseMetaobjectProtocol;
import org.dynalang.mop.CallProtocol;
import org.dynalang.mop.beans.ClassMetaobjectProtocol;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ArrayClassMetaobjectProtocol
extends ClassMetaobjectProtocol {
    private final Class componentType;
    private static final Set<Object> lengthSet = Collections.singleton("length");

    ArrayClassMetaobjectProtocol(Class clazz, boolean methodsEnumerable) throws IntrospectionException {
        super(clazz, methodsEnumerable);
        this.componentType = clazz.getComponentType();
    }

    @Override
    Object get(Object target, Object propertyId) {
        if (propertyId instanceof Number) {
            return this.get(target, ((Number)propertyId).longValue());
        }
        if ("length".equals(propertyId)) {
            return Array.getLength(target);
        }
        return super.get(target, propertyId);
    }

    @Override
    Object get(Object target, long propertyId) {
        return ArrayClassMetaobjectProtocol.isWithinBounds(target, propertyId) ? Array.get(target, (int)propertyId) : BaseMetaobjectProtocol.Results.doesNotExist;
    }

    @Override
    Boolean has(Object target, Object propertyId) {
        if (propertyId instanceof Number) {
            return this.has(target, ((Number)propertyId).longValue());
        }
        if ("length".equals(propertyId)) {
            return Boolean.TRUE;
        }
        return super.has(target, propertyId);
    }

    @Override
    Boolean has(Object target, long propertyId) {
        return ArrayClassMetaobjectProtocol.isWithinBounds(target, propertyId);
    }

    Iterator<? extends Object> getSuperPropertyIds(Object target) {
        return super.getPropertyIds(target);
    }

    Iterator<Object> getPropertyIds(final Object target) {
        return new Iterator<Object>(){
            private Iterator<? extends Object> curr = new Iterator<Integer>(){
                private int i = 0;
                private final int l;
                {
                    this.l = Array.getLength(target);
                }

                @Override
                public boolean hasNext() {
                    return this.i < this.l;
                }

                @Override
                public Integer next() {
                    if (this.i < this.l) {
                        return this.i++;
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
            private PropertyIterationPhase phase = PropertyIterationPhase.array;

            @Override
            public boolean hasNext() {
                do {
                    if (!this.curr.hasNext()) continue;
                    return true;
                } while (this.switchState());
                return false;
            }

            private boolean switchState() {
                switch (this.phase) {
                    case array: {
                        this.phase = PropertyIterationPhase.length;
                        this.curr = lengthSet.iterator();
                        return true;
                    }
                    case length: {
                        this.phase = PropertyIterationPhase.methods;
                        this.curr = ArrayClassMetaobjectProtocol.this.getSuperPropertyIds(target);
                        return true;
                    }
                    case methods: {
                        return false;
                    }
                }
                throw new AssertionError();
            }

            @Override
            public Object next() {
                while (true) {
                    try {
                        return this.curr.next();
                    }
                    catch (NoSuchElementException e) {
                        if (this.switchState()) continue;
                        throw e;
                    }
                    break;
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    BaseMetaobjectProtocol.Results put(Object target, Object propertyId, Object value, CallProtocol callProtocol) {
        if (propertyId instanceof Number) {
            return this.put(target, ((Number)propertyId).longValue(), value, callProtocol);
        }
        if ("length".equals(propertyId)) {
            return BaseMetaobjectProtocol.Results.notWritable;
        }
        return super.put(target, propertyId, value, callProtocol);
    }

    @Override
    BaseMetaobjectProtocol.Results put(Object target, long propertyId, Object value, CallProtocol callProtocol) {
        if (ArrayClassMetaobjectProtocol.isWithinBounds(target, propertyId)) {
            if ((value = callProtocol.representAs(value, this.componentType)) == BaseMetaobjectProtocol.Results.noAuthority || value == BaseMetaobjectProtocol.Results.noRepresentation) {
                return BaseMetaobjectProtocol.Results.noRepresentation;
            }
            Array.set(target, (int)propertyId, value);
            return BaseMetaobjectProtocol.Results.ok;
        }
        return BaseMetaobjectProtocol.Results.doesNotExist;
    }

    private static boolean isWithinBounds(Object target, long propertyId) {
        return 0L <= propertyId && propertyId < (long)Array.getLength(target);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum PropertyIterationPhase {
        array,
        length,
        methods;

    }
}

