/*
 * Decompiled with CFR 0.152.
 */
package java.dyn.util;

import java.dyn.AnonymousClassLoader;
import java.dyn.ConstantPoolParser;
import java.dyn.ConstantPoolPatch;
import java.dyn.ConstantPoolVisitor;
import java.dyn.InvalidConstantPoolFormatException;
import java.dyn.MethodHandle;
import java.dyn.MethodType;
import java.dyn.Wrappers;
import java.dyn.WrongMethodTypeException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.IdentityHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MethodHandleInvoker {
    protected final MethodType type;
    private static final AnonymousClassLoader LOADER = new AnonymousClassLoader(MethodHandleInvoker.class);
    static final IdentityHashMap<MethodType, MethodHandleInvoker> invokers = new IdentityHashMap();
    static final int fV = 0;
    static final int fL = 1;
    static final int fI = 2;
    static final int fJ = 3;
    static final int fF = 4;
    static final int fD = 5;
    static final String FP_SIGCHARS = "VLIJFD";
    static final int fRw = 4;
    static final int fAw = 3;
    static final int fA0 = 4;
    static final int fA1 = 7;
    static final int fA2 = 10;
    static final int fA3 = 13;
    static final int fA_MAX = 9;
    static final int fR_MASK = 15;
    static final int fA_MASK = 7;

    public MethodType type() {
        return this.type;
    }

    protected MethodHandleInvoker(MethodType methodType) {
        this.type = methodType;
    }

    public void invoke_V(MethodHandle methodHandle) {
        throw this.wrongType(methodHandle);
    }

    public Object invoke_L(MethodHandle methodHandle) {
        throw this.wrongType(methodHandle);
    }

    public long invoke_J(MethodHandle methodHandle) {
        throw this.wrongType(methodHandle);
    }

    public double invoke_D(MethodHandle methodHandle) {
        throw this.wrongType(methodHandle);
    }

    public Object invoke_LL(MethodHandle methodHandle, Object object) {
        throw this.wrongType(methodHandle);
    }

    public Object invoke_LI(MethodHandle methodHandle, int n) {
        throw this.wrongType(methodHandle);
    }

    public Object invoke_LLL(MethodHandle methodHandle, Object object, Object object2) {
        throw this.wrongType(methodHandle);
    }

    public Object invoke_LLI(MethodHandle methodHandle, Object object, int n) {
        throw this.wrongType(methodHandle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MethodHandleInvoker make(MethodType methodType) {
        MethodHandleInvoker methodHandleInvoker = null;
        Class clazz = invokers;
        synchronized (clazz) {
            methodHandleInvoker = invokers.get(methodType);
        }
        if (methodHandleInvoker != null) {
            return methodHandleInvoker;
        }
        clazz = null;
        Class<? extends MethodHandleInvoker> clazz2 = null;
        Constructor<? extends MethodHandleInvoker> constructor = null;
        int n = MethodHandleInvoker.fingerprint(methodType);
        switch (n) {
            case 0: {
                clazz = V.class;
                break;
            }
            case 1: {
                clazz = L.class;
                break;
            }
            case 17: {
                clazz = LL.class;
                break;
            }
            case 33: {
                clazz = LI.class;
                break;
            }
            case 145: {
                clazz = LLL.class;
                break;
            }
            case 273: {
                clazz = LLI.class;
            }
        }
        if (clazz == null) {
            throw new UnsupportedOperationException("NYI: No template for " + methodType + ", fp=" + Integer.toHexString(n));
        }
        try {
            clazz2 = MethodHandleInvoker.expandTemplate(clazz, n, methodType);
            constructor = clazz2.getConstructor(MethodType.class);
            methodHandleInvoker = constructor.newInstance(methodType);
        }
        catch (IOException iOException) {
            MethodHandleInvoker.printex(iOException);
        }
        catch (InvalidConstantPoolFormatException invalidConstantPoolFormatException) {
            MethodHandleInvoker.printex(invalidConstantPoolFormatException);
        }
        catch (InstantiationException instantiationException) {
            MethodHandleInvoker.printex(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            MethodHandleInvoker.printex(illegalAccessException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            MethodHandleInvoker.printex(noSuchMethodException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            MethodHandleInvoker.printex(illegalArgumentException);
        }
        catch (InvocationTargetException invocationTargetException) {
            MethodHandleInvoker.printex(invocationTargetException);
        }
        if (methodHandleInvoker == null) {
            throw new UnsupportedOperationException("NYI");
        }
        IdentityHashMap<MethodType, MethodHandleInvoker> identityHashMap = invokers;
        synchronized (identityHashMap) {
            MethodHandleInvoker methodHandleInvoker2 = invokers.get(methodType);
            if (methodHandleInvoker2 == null) {
                invokers.put(methodType, methodHandleInvoker);
            } else {
                methodHandleInvoker = methodHandleInvoker2;
            }
        }
        return methodHandleInvoker;
    }

    private static void printex(Exception exception) {
        System.out.println("*** Unexpected exception in " + MethodHandleInvoker.class);
        System.out.println(exception);
        exception.printStackTrace(System.out);
    }

    private static String utf8Name(Class<?> clazz) {
        return clazz.getName().replace('.', '/');
    }

    private static Class<? extends MethodHandleInvoker> expandTemplate(Class<? extends MethodHandleInvoker> clazz, int n, MethodType methodType) throws IOException, InvalidConstantPoolFormatException {
        TemplateExpander templateExpander = new TemplateExpander(clazz, n, methodType);
        return LOADER.loadClass(templateExpander.patch).asSubclass(MethodHandleInvoker.class);
    }

    static int fingerprint(MethodType methodType) {
        int n = methodType.parameterCount();
        if (n > 9) {
            return -1;
        }
        int n2 = MethodHandleInvoker.fingerprint(methodType.returnType());
        int n3 = 4;
        for (int i = 0; i < n; ++i) {
            n2 |= MethodHandleInvoker.fingerprint(methodType.parameterType(i)) << n3;
            n3 += 3;
        }
        assert (n3 <= 32);
        return n2;
    }

    static int fingerprint(Class<?> clazz) {
        char c = Wrappers.basicTypeChar(clazz);
        int n = FP_SIGCHARS.indexOf(c);
        assert (n >= 0 || "ZCBS".indexOf(c) >= 0);
        return n >= 0 ? n : 2;
    }

    static String fingerprintName(int n) {
        assert (n != -1);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(FP_SIGCHARS.charAt(n & 7));
        n >>>= 4;
        while (n != 0) {
            stringBuilder.append(FP_SIGCHARS.charAt(n & 7));
            n >>>= 3;
        }
        return stringBuilder.toString();
    }

    static Object[] fingerprintInvokeDescriptor(int n) {
        String string = MethodHandleInvoker.fingerprintName(n);
        Class[] classArray = new Class[string.length() - 1];
        Class<?> clazz = Wrappers.basicTypeFromChar(string.charAt(0));
        for (int i = 0; i < classArray.length; ++i) {
            classArray[i] = Wrappers.basicTypeFromChar(string.charAt(i + 1));
        }
        String string2 = "invoke_" + string;
        MethodType methodType = MethodType.make(clazz, classArray);
        return new Object[]{string2, methodType};
    }

    protected RuntimeException wrongType(MethodHandle methodHandle) {
        return new WrongMethodTypeException("wrong call type for " + methodHandle + " should be " + this.type + " in " + this);
    }

    protected void checkType(MethodHandle methodHandle) {
        if (methodHandle.type() != this.type) {
            throw this.wrongType(methodHandle);
        }
    }

    static /* synthetic */ String access$000(Class clazz) {
        return MethodHandleInvoker.utf8Name(clazz);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TemplateExpander
    extends ConstantPoolVisitor {
        ConstantPoolParser cp;
        ConstantPoolPatch patch;
        String fakeMHName = MethodHandleInvoker.access$000(FakeMethodHandle.class);
        String realMHName = MethodHandleInvoker.access$000(MethodHandle.class);
        boolean didMHName;
        String fakeInvokeName;
        String realInvokeName = "invoke";
        String fakeInvokeSig;
        String realInvokeSig;
        boolean didInvokeName;
        boolean didInvokeSig;

        @Override
        public void visitUTF8(int n, byte by, String string) {
            String string2 = string;
            if (string.equals(this.fakeMHName)) {
                string = this.realMHName;
                this.didMHName = true;
            }
            if (string.equals(this.fakeInvokeName)) {
                string = this.realInvokeName;
                this.didInvokeName = true;
            }
            if (string.equals(this.fakeInvokeSig)) {
                string = this.realInvokeSig;
                this.didInvokeSig = true;
            }
            if (string != string2) {
                this.patch.putUTF8(n, string);
            }
        }

        public TemplateExpander(Class<? extends MethodHandleInvoker> clazz, int n, MethodType methodType) throws IOException, InvalidConstantPoolFormatException {
            Object[] objectArray = MethodHandleInvoker.fingerprintInvokeDescriptor(n);
            MethodType methodType2 = (MethodType)objectArray[1];
            if (methodType.erase() != methodType2) {
                throw new RuntimeException("what?? " + methodType + " !eraseTo " + methodType2);
            }
            this.fakeInvokeSig = methodType2.toBytecodeString();
            this.realInvokeSig = methodType.toBytecodeString();
            this.fakeInvokeName = "fake_" + objectArray[0];
            this.cp = new ConstantPoolParser(clazz);
            this.patch = this.cp.createPatch();
            this.cp.parse(this);
            if (!(this.didMHName && this.didInvokeName && this.didInvokeSig)) {
                throw new RuntimeException("utf8 rewrites failed");
            }
        }
    }

    static class LLI
    extends MethodHandleInvoker {
        static final int FINGERPRINT = 273;

        public LLI(MethodType methodType) {
            super(methodType);
        }

        public Object invoke_LLI(MethodHandle methodHandle, Object object, int n) {
            this.checkType(methodHandle);
            return ((FakeMethodHandle)methodHandle).fake_invoke_LLI(object, n);
        }
    }

    static class LLL
    extends MethodHandleInvoker {
        static final int FINGERPRINT = 145;

        public LLL(MethodType methodType) {
            super(methodType);
        }

        public Object invoke_LLL(MethodHandle methodHandle, Object object, Object object2) {
            this.checkType(methodHandle);
            return ((FakeMethodHandle)methodHandle).fake_invoke_LLL(object, object2);
        }
    }

    static class LI
    extends MethodHandleInvoker {
        static final int FINGERPRINT = 33;

        public LI(MethodType methodType) {
            super(methodType);
        }

        public Object invoke_LI(MethodHandle methodHandle, int n) {
            this.checkType(methodHandle);
            return ((FakeMethodHandle)methodHandle).fake_invoke_LI(n);
        }
    }

    static class LL
    extends MethodHandleInvoker {
        static final int FINGERPRINT = 17;

        public LL(MethodType methodType) {
            super(methodType);
        }

        public Object invoke_LL(MethodHandle methodHandle, Object object) {
            this.checkType(methodHandle);
            return ((FakeMethodHandle)methodHandle).fake_invoke_LL(object);
        }
    }

    static class L
    extends MethodHandleInvoker {
        static final int FINGERPRINT = 1;

        public L(MethodType methodType) {
            super(methodType);
        }

        public Object invoke_L(MethodHandle methodHandle) {
            this.checkType(methodHandle);
            return ((FakeMethodHandle)methodHandle).fake_invoke_L();
        }
    }

    static class V
    extends MethodHandleInvoker {
        static final int FINGERPRINT = 0;

        public V(MethodType methodType) {
            super(methodType);
        }

        public void invoke_V(MethodHandle methodHandle) {
            this.checkType(methodHandle);
            ((FakeMethodHandle)methodHandle).fake_invoke_V();
        }
    }

    private static abstract class FakeMethodHandle
    extends MethodHandle {
        public FakeMethodHandle() {
            super(null, null);
        }

        public abstract void fake_invoke_V();

        public abstract Object fake_invoke_L();

        public abstract long fake_invoke_J();

        public abstract double fake_invoke_D();

        public abstract Object fake_invoke_LL(Object var1);

        public abstract Object fake_invoke_LI(int var1);

        public abstract Object fake_invoke_LLL(Object var1, Object var2);

        public abstract Object fake_invoke_LLI(Object var1, int var2);
    }
}

