/* diskicondata.c generated by valac 0.12.0, the Vala compiler
 * generated from diskicondata.vala, do not modify */


#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <glib/gstdio.h>
#include <glibtop/mountlist.h>
#include <glibtop/fsusage.h>
#include <glib/gi18n-lib.h>


#define TYPE_ICON_DATA (icon_data_get_type ())
#define ICON_DATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ICON_DATA, IconData))
#define ICON_DATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ICON_DATA, IconDataClass))
#define IS_ICON_DATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ICON_DATA))
#define IS_ICON_DATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ICON_DATA))
#define ICON_DATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ICON_DATA, IconDataClass))

typedef struct _IconData IconData;
typedef struct _IconDataClass IconDataClass;
typedef struct _IconDataPrivate IconDataPrivate;

#define TYPE_DISK_ICON_DATA (disk_icon_data_get_type ())
#define DISK_ICON_DATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DISK_ICON_DATA, DiskIconData))
#define DISK_ICON_DATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DISK_ICON_DATA, DiskIconDataClass))
#define IS_DISK_ICON_DATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DISK_ICON_DATA))
#define IS_DISK_ICON_DATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DISK_ICON_DATA))
#define DISK_ICON_DATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DISK_ICON_DATA, DiskIconDataClass))

typedef struct _DiskIconData DiskIconData;
typedef struct _DiskIconDataClass DiskIconDataClass;
typedef struct _DiskIconDataPrivate DiskIconDataPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))

#define TYPE_ICON_TRACE_DATA (icon_trace_data_get_type ())
#define ICON_TRACE_DATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ICON_TRACE_DATA, IconTraceData))
#define ICON_TRACE_DATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ICON_TRACE_DATA, IconTraceDataClass))
#define IS_ICON_TRACE_DATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ICON_TRACE_DATA))
#define IS_ICON_TRACE_DATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ICON_TRACE_DATA))
#define ICON_TRACE_DATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ICON_TRACE_DATA, IconTraceDataClass))

typedef struct _IconTraceData IconTraceData;
typedef struct _IconTraceDataClass IconTraceDataClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _IconData {
	GObject parent_instance;
	IconDataPrivate * priv;
};

struct _IconDataClass {
	GObjectClass parent_class;
	void (*update) (IconData* self);
	void (*update_scale) (IconData* self);
};

struct _DiskIconData {
	IconData parent_instance;
	DiskIconDataPrivate * priv;
};

struct _DiskIconDataClass {
	IconDataClass parent_class;
};

struct _DiskIconDataPrivate {
	guint64* lastdata;
	gint lastdata_length1;
	gint _lastdata_size_;
	guint64 lasttime;
};


static gpointer disk_icon_data_parent_class = NULL;

GType icon_data_get_type (void) G_GNUC_CONST;
GType disk_icon_data_get_type (void) G_GNUC_CONST;
#define DISK_ICON_DATA_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_DISK_ICON_DATA, DiskIconDataPrivate))
enum  {
	DISK_ICON_DATA_DUMMY_PROPERTY
};
DiskIconData* disk_icon_data_new (void);
DiskIconData* disk_icon_data_construct (GType object_type);
IconData* icon_data_construct (GType object_type, const gchar* id, guint traces, guint scalerdelay, gdouble scalerminimum);
static gchar** disk_icon_data_split (DiskIconData* self, const gchar* val, int* result_length1);
static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value);
static void disk_icon_data_real_update (IconData* base);
static gboolean _vala_string_array_contains (const gchar** stack, int stack_length, const gchar* needle);
GType icon_trace_data_get_type (void) G_GNUC_CONST;
IconTraceData** icon_data_get_traces (IconData* self, int* result_length1);
void icon_trace_data_add_value (IconTraceData* self, gdouble value);
static guint64* _vala_array_dup2 (guint64* self, int length);
gchar* utils_format_speed (gdouble val);
void icon_data_set_menuitems (IconData* self, gchar** value, int value_length1);
void icon_data_update_scale (IconData* self);
static void disk_icon_data_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const gchar* DISK_ICON_DATA_networkfs[4] = {"smbfs", "nfs", "cifs", "fuse.sshfs"};

DiskIconData* disk_icon_data_construct (GType object_type) {
	DiskIconData * self = NULL;
	self = (DiskIconData*) icon_data_construct (object_type, "diskload", (guint) 2, (guint) 10, (gdouble) 1000);
	return self;
}


DiskIconData* disk_icon_data_new (void) {
	return disk_icon_data_construct (TYPE_DISK_ICON_DATA);
}


static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gchar** disk_icon_data_split (DiskIconData* self, const gchar* val, int* result_length1) {
	gchar** result = NULL;
	gchar** _result_;
	gint _result__length1;
	gint __result__size_;
	gchar* last;
	gchar* current;
	gchar** _tmp4_;
	g_return_val_if_fail (IS_DISK_ICON_DATA (self), NULL);
	g_return_val_if_fail (val != NULL, NULL);
	_result_ = NULL;
	_result__length1 = 0;
	__result__size_ = 0;
	last = NULL;
	current = val;
	{
		gboolean _tmp0_;
		_tmp0_ = TRUE;
		while (TRUE) {
			gboolean _tmp1_ = FALSE;
			if (!_tmp0_) {
				current = current + 1;
			}
			_tmp0_ = FALSE;
			if (!((*current) != '\0')) {
				break;
			}
			if ((*current) == ' ') {
				_tmp1_ = TRUE;
			} else {
				_tmp1_ = (*current) == '\n';
			}
			if (_tmp1_) {
				if (last != NULL) {
					gchar* _tmp2_ = NULL;
					_tmp2_ = g_strndup (last, current - last);
					_vala_array_add1 (&_result_, &_result__length1, &__result__size_, _tmp2_);
					last = NULL;
				}
			} else {
				if (last == NULL) {
					last = current;
				}
			}
		}
	}
	if (last != NULL) {
		gchar* _tmp3_ = NULL;
		_tmp3_ = g_strndup (last, current - last);
		_vala_array_add2 (&_result_, &_result__length1, &__result__size_, _tmp3_);
	}
	_tmp4_ = _result_;
	*result_length1 = _result__length1;
	result = _tmp4_;
	return result;
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static guint64 uint64_parse (const gchar* str) {
	guint64 result = 0ULL;
	guint64 _tmp0_;
	g_return_val_if_fail (str != NULL, 0ULL);
	_tmp0_ = g_ascii_strtoull (str, NULL, (guint) 0);
	result = _tmp0_;
	return result;
}


static gboolean _vala_string_array_contains (const gchar** stack, int stack_length, const gchar* needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static guint64* _vala_array_dup2 (guint64* self, int length) {
	return g_memdup (self, length * sizeof (guint64));
}


static void disk_icon_data_real_update (IconData* base) {
	DiskIconData * self;
	guint64* _tmp0_ = NULL;
	guint64* newdata;
	gint newdata_length1;
	gint _newdata_size_;
	guint64 _tmp1_;
	guint64 newtime;
	GDir* _tmp2_ = NULL;
	GDir* directory;
	gchar* entry = NULL;
	gdouble read;
	gdouble write;
	guint64* _tmp31_;
	guint64* _tmp32_;
	const gchar* _tmp33_ = NULL;
	gchar* _tmp34_ = NULL;
	gchar* _tmp35_;
	gchar* _tmp36_ = NULL;
	gchar* _tmp37_;
	gchar* _tmp38_ = NULL;
	gchar** _tmp39_ = NULL;
	gchar** _tmp40_;
	gint _tmp40__length1;
	gchar** _tmp41_;
	GError * _inner_error_ = NULL;
	self = DISK_ICON_DATA (base);
	_tmp0_ = g_new0 (guint64, 3);
	newdata = _tmp0_;
	newdata_length1 = 3;
	_newdata_size_ = 3;
	_tmp1_ = g_get_monotonic_time ();
	newtime = _tmp1_;
	_tmp2_ = g_dir_open ("/sys/block", (guint) 0, &_inner_error_);
	directory = _tmp2_;
	if (_inner_error_ != NULL) {
		goto __catch0_g_error;
	}
	while (TRUE) {
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_;
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		gboolean _tmp8_;
		gboolean _tmp9_;
		gchar* stat = NULL;
		const gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_;
		gchar* _tmp13_ = NULL;
		gint _tmp14_;
		gchar** _tmp15_ = NULL;
		gchar** stats;
		gint stats_length1;
		gint _stats_size_;
		guint64 _tmp16_;
		guint64 _tmp17_;
		_tmp3_ = g_dir_read_name (directory);
		_tmp4_ = g_strdup (_tmp3_);
		_g_free0 (entry);
		entry = _tmp4_;
		if (!(entry != NULL)) {
			break;
		}
		_tmp5_ = string_to_string (entry);
		_tmp6_ = g_strconcat ("/sys/block/", _tmp5_, "/device", NULL);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_file_test (_tmp7_, G_FILE_TEST_EXISTS);
		_tmp9_ = !_tmp8_;
		_g_free0 (_tmp7_);
		if (_tmp9_) {
			continue;
		}
		_tmp10_ = string_to_string (entry);
		_tmp11_ = g_strconcat ("/sys/block/", _tmp10_, "/stat", NULL);
		_tmp12_ = _tmp11_;
		g_file_get_contents (_tmp12_, &_tmp13_, NULL, &_inner_error_);
		_g_free0 (stat);
		stat = _tmp13_;
		_g_free0 (_tmp12_);
		if (_inner_error_ != NULL) {
			goto __catch1_g_error;
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			_g_error_free0 (e);
			_g_free0 (stat);
			continue;
		}
		__finally1:
		if (_inner_error_ != NULL) {
			_g_free0 (stat);
			_g_free0 (entry);
			_g_dir_close0 (directory);
			goto __catch0_g_error;
		}
		_tmp15_ = disk_icon_data_split (self, stat, &_tmp14_);
		stats = _tmp15_;
		stats_length1 = _tmp14_;
		_stats_size_ = _tmp14_;
		if (stats_length1 < 8) {
			stats = (_vala_array_free (stats, stats_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (stat);
			continue;
		}
		_tmp16_ = uint64_parse (stats[2]);
		newdata[0] += 512 * _tmp16_;
		_tmp17_ = uint64_parse (stats[6]);
		newdata[1] += 512 * _tmp17_;
		stats = (_vala_array_free (stats, stats_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (stat);
	}
	_g_free0 (entry);
	_g_dir_close0 (directory);
	goto __finally0;
	__catch0_g_error:
	{
		GError * e;
		glibtop_mountentry* mountentries = NULL;
		gint mountentries_length1 = 0;
		gint _mountentries_size_ = 0;
		glibtop_mountlist mountlist = {0};
		glibtop_mountlist _tmp18_ = {0};
		glibtop_mountentry* _tmp19_;
		glibtop_mountentry* _tmp20_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp20_ = _tmp19_ = glibtop_get_mountlist (&_tmp18_, FALSE);
		mountlist = _tmp18_;
		mountentries = (g_free (mountentries), NULL);
		mountentries = _tmp20_;
		mountentries_length1 = _vala_array_length (_tmp19_);
		_mountentries_size_ = _vala_array_length (_tmp19_);
		{
			guint i;
			i = (guint) 0;
			{
				gboolean _tmp21_;
				_tmp21_ = TRUE;
				while (TRUE) {
					glibtop_fsusage fsusage = {0};
					glibtop_fsusage _tmp22_ = {0};
					if (!_tmp21_) {
						i = i + 1;
					}
					_tmp21_ = FALSE;
					if (!(i < mountlist.number)) {
						break;
					}
					if (_vala_string_array_contains (DISK_ICON_DATA_networkfs, G_N_ELEMENTS (DISK_ICON_DATA_networkfs), mountentries[i].type)) {
						continue;
					}
					glibtop_get_fsusage (&_tmp22_, mountentries[i].mountdir);
					fsusage = _tmp22_;
					newdata[0] += fsusage.block_size * fsusage.read;
					newdata[1] += fsusage.block_size * fsusage.write;
				}
			}
		}
		mountentries = (g_free (mountentries), NULL);
		_g_error_free0 (e);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		newdata = (g_free (newdata), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	read = (gdouble) 0;
	write = (gdouble) 0;
	if (self->priv->lastdata_length1 == 0) {
		IconTraceData** _tmp23_ = NULL;
		gint _tmp24_;
		_tmp23_ = icon_data_get_traces (ICON_DATA (self), &_tmp24_);
		{
			IconTraceData** trace_collection;
			int trace_collection_length1;
			int trace_it;
			trace_collection = _tmp23_;
			trace_collection_length1 = _tmp24_;
			for (trace_it = 0; trace_it < _tmp24_; trace_it = trace_it + 1) {
				IconTraceData* _tmp25_;
				IconTraceData* trace;
				_tmp25_ = _g_object_ref0 (trace_collection[trace_it]);
				trace = _tmp25_;
				{
					icon_trace_data_add_value (trace, (gdouble) 0);
					_g_object_unref0 (trace);
				}
			}
		}
	} else {
		gdouble delta;
		delta = (newtime - self->priv->lasttime) / 1e6;
		read = (newdata[0] - self->priv->lastdata[0]) / delta;
		write = (newdata[1] - self->priv->lastdata[1]) / delta;
		{
			guint i;
			IconTraceData** _tmp26_ = NULL;
			gint _tmp27_;
			guint isize;
			i = (guint) 0;
			_tmp26_ = icon_data_get_traces (ICON_DATA (self), &_tmp27_);
			isize = (guint) _tmp27_;
			{
				gboolean _tmp28_;
				_tmp28_ = TRUE;
				while (TRUE) {
					IconTraceData** _tmp29_ = NULL;
					gint _tmp30_;
					if (!_tmp28_) {
						i = i + 1;
					}
					_tmp28_ = FALSE;
					if (!(i < isize)) {
						break;
					}
					_tmp29_ = icon_data_get_traces (ICON_DATA (self), &_tmp30_);
					icon_trace_data_add_value (_tmp29_[i], (newdata[i] - self->priv->lastdata[i]) / delta);
				}
			}
		}
	}
	_tmp31_ = (_tmp32_ = newdata, (_tmp32_ == NULL) ? ((gpointer) _tmp32_) : _vala_array_dup2 (_tmp32_, newdata_length1));
	self->priv->lastdata = (g_free (self->priv->lastdata), NULL);
	self->priv->lastdata = _tmp31_;
	self->priv->lastdata_length1 = newdata_length1;
	self->priv->_lastdata_size_ = newdata_length1;
	self->priv->lasttime = newtime;
	_tmp33_ = _ ("Disk: read %s, write %s");
	_tmp34_ = utils_format_speed (read);
	_tmp35_ = _tmp34_;
	_tmp36_ = utils_format_speed (write);
	_tmp37_ = _tmp36_;
	_tmp38_ = g_strdup_printf (_tmp33_, _tmp35_, _tmp37_);
	_tmp39_ = g_new0 (gchar*, 1 + 1);
	_tmp39_[0] = _tmp38_;
	_tmp40_ = _tmp39_;
	_tmp40__length1 = 1;
	_tmp41_ = _tmp40_;
	icon_data_set_menuitems (ICON_DATA (self), _tmp41_, 1);
	_tmp40_ = (_vala_array_free (_tmp40_, _tmp40__length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (_tmp37_);
	_g_free0 (_tmp35_);
	icon_data_update_scale (ICON_DATA (self));
	newdata = (g_free (newdata), NULL);
}


static void disk_icon_data_class_init (DiskIconDataClass * klass) {
	disk_icon_data_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DiskIconDataPrivate));
	ICON_DATA_CLASS (klass)->update = disk_icon_data_real_update;
	G_OBJECT_CLASS (klass)->finalize = disk_icon_data_finalize;
}


static void disk_icon_data_instance_init (DiskIconData * self) {
	self->priv = DISK_ICON_DATA_GET_PRIVATE (self);
}


static void disk_icon_data_finalize (GObject* obj) {
	DiskIconData * self;
	self = DISK_ICON_DATA (obj);
	self->priv->lastdata = (g_free (self->priv->lastdata), NULL);
	G_OBJECT_CLASS (disk_icon_data_parent_class)->finalize (obj);
}


/******************************************************************************
 * Copyright (C) 2011  Michael Hofmann <mh21@piware.de>                       *
 *                                                                            *
 * This program is free software; you can redistribute it and/or modify       *
 * it under the terms of the GNU General Public License as published by       *
 * the Free Software Foundation; either version 3 of the License, or          *
 * (at your option) any later version.                                        *
 *                                                                            *
 * This program is distributed in the hope that it will be useful,            *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              *
 * GNU General Public License for more details.                               *
 *                                                                            *
 * You should have received a copy of the GNU General Public License along    *
 * with this program; if not, write to the Free Software Foundation, Inc.,    *
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.                *
 ******************************************************************************/
GType disk_icon_data_get_type (void) {
	static volatile gsize disk_icon_data_type_id__volatile = 0;
	if (g_once_init_enter (&disk_icon_data_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DiskIconDataClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) disk_icon_data_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DiskIconData), 0, (GInstanceInitFunc) disk_icon_data_instance_init, NULL };
		GType disk_icon_data_type_id;
		disk_icon_data_type_id = g_type_register_static (TYPE_ICON_DATA, "DiskIconData", &g_define_type_info, 0);
		g_once_init_leave (&disk_icon_data_type_id__volatile, disk_icon_data_type_id);
	}
	return disk_icon_data_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



