"""A dummy implemetation of objects."""


#line 3 "gedit.overrides"
# Copyright (C) 2007-2009 - Curtis Hovey <sinzui.is at verizon.net>
# This software is licensed under the GNU General Public License version 2
# (see the file COPYING).

__metaclass__ = type


from testing import Dummy

import __builtin__
from gettext import gettext
from gettext import gettext as _
import gobject
from gobject import *
import gtk
import gtksourceview2


GEDIT_TAB_STATE_NORMAL = 'normal'
GEDIT_TAB_STATE_LOADING = 'loading'
GEDIT_TAB_STATE_REVERTING = 'reverting'
GEDIT_TAB_STATE_SAVING = 'saving'
GEDIT_TAB_STATE_PRINTING = 'printing'
GEDIT_TAB_STATE_PRINT_PREVIEWING = 'print-previewing'
GEDIT_TAB_STATE_SHOWING_PRINT_PREVIEW = 'showing-print-preview'
GEDIT_TAB_STATE_GENERIC_NOT_EDITABLE = 'generic-not-editable'
GEDIT_TAB_STATE_LOADING_ERROR = 'loading-error'
GEDIT_TAB_STATE_REVERTING_ERROR = 'reverting-error'
GEDIT_TAB_STATE_SAVING_ERROR = 'saving-error'
GEDIT_TAB_STATE_GENERIC_ERROR = 'generic-error'
GEDIT_TAB_STATE_CLOSING = 'closing'

dummy = Dummy()


def gedit_app_get_type():
    """A dummy implementation of gedit_app_get_type."""
    if 'gedit_app_get_type' in dummy:
        return dummy['gedit_app_get_type']
    else:
        raise NotImplementedError

def gedit_app_get_default():
    """A dummy implementation of gedit_app_get_default."""
    if 'gedit_app_get_default' in dummy:
        return dummy['gedit_app_get_default']
    else:
        raise NotImplementedError

def document_error_quark():
    """A dummy implementation of document_error_quark."""
    if 'document_error_quark' in dummy:
        return dummy['document_error_quark']
    else:
        raise NotImplementedError

def gedit_document_get_type():
    """A dummy implementation of gedit_document_get_type."""
    if 'gedit_document_get_type' in dummy:
        return dummy['gedit_document_get_type']
    else:
        raise NotImplementedError

def gedit_document_new():
    """A dummy implementation of gedit_document_new."""
    if 'gedit_document_new' in dummy:
        return dummy['gedit_document_new']
    else:
        raise NotImplementedError

def gedit_encoding_get_type():
    """A dummy implementation of gedit_encoding_get_type."""
    if 'gedit_encoding_get_type' in dummy:
        return dummy['gedit_encoding_get_type']
    else:
        raise NotImplementedError

def encoding_get_from_charset(charset):
    """A dummy implementation of encoding_get_from_charset."""
    if 'encoding_get_from_charset' in dummy:
        return dummy['encoding_get_from_charset']
    else:
        raise NotImplementedError

def gedit_encoding_get_from_charset(charset):
    """A dummy implementation of gedit_encoding_get_from_charset."""
    if 'gedit_encoding_get_from_charset' in dummy:
        return dummy['gedit_encoding_get_from_charset']
    else:
        raise NotImplementedError

def encoding_get_from_index(index):
    """A dummy implementation of encoding_get_from_index."""
    if 'encoding_get_from_index' in dummy:
        return dummy['encoding_get_from_index']
    else:
        raise NotImplementedError

def gedit_encoding_get_from_index(index):
    """A dummy implementation of gedit_encoding_get_from_index."""
    if 'gedit_encoding_get_from_index' in dummy:
        return dummy['gedit_encoding_get_from_index']
    else:
        raise NotImplementedError

def encoding_get_utf8():
    """A dummy implementation of encoding_get_utf8."""
    if 'encoding_get_utf8' in dummy:
        return dummy['encoding_get_utf8']
    else:
        raise NotImplementedError

def gedit_encoding_get_utf8():
    """A dummy implementation of gedit_encoding_get_utf8."""
    if 'gedit_encoding_get_utf8' in dummy:
        return dummy['gedit_encoding_get_utf8']
    else:
        raise NotImplementedError

def encoding_get_current():
    """A dummy implementation of encoding_get_current."""
    if 'encoding_get_current' in dummy:
        return dummy['encoding_get_current']
    else:
        raise NotImplementedError

def gedit_encoding_get_current():
    """A dummy implementation of gedit_encoding_get_current."""
    if 'gedit_encoding_get_current' in dummy:
        return dummy['gedit_encoding_get_current']
    else:
        raise NotImplementedError

def help_display(parent, file_name, link_id):
    """A dummy implementation of help_display."""
    if 'help_display' in dummy:
        return dummy['help_display']
    else:
        raise NotImplementedError

def gedit_panel_get_type():
    """A dummy implementation of gedit_panel_get_type."""
    if 'gedit_panel_get_type' in dummy:
        return dummy['gedit_panel_get_type']
    else:
        raise NotImplementedError

def gedit_panel_new():
    """A dummy implementation of gedit_panel_new."""
    if 'gedit_panel_new' in dummy:
        return dummy['gedit_panel_new']
    else:
        raise NotImplementedError

def gedit_plugin_get_type():
    """A dummy implementation of gedit_plugin_get_type."""
    if 'gedit_plugin_get_type' in dummy:
        return dummy['gedit_plugin_get_type']
    else:
        raise NotImplementedError

def gedit_tab_get_type():
    """A dummy implementation of gedit_tab_get_type."""
    if 'gedit_tab_get_type' in dummy:
        return dummy['gedit_tab_get_type']
    else:
        raise NotImplementedError

def tab_get_from_document(doc):
    """A dummy implementation of tab_get_from_document."""
    if 'tab_get_from_document' in dummy:
        return dummy['tab_get_from_document']
    else:
        raise NotImplementedError

def gedit_tab_get_from_document(doc):
    """A dummy implementation of gedit_tab_get_from_document."""
    if 'gedit_tab_get_from_document' in dummy:
        return dummy['gedit_tab_get_from_document']
    else:
        raise NotImplementedError

def gedit_view_get_type():
    """A dummy implementation of gedit_view_get_type."""
    if 'gedit_view_get_type' in dummy:
        return dummy['gedit_view_get_type']
    else:
        raise NotImplementedError

def gedit_view_new(doc):
    """A dummy implementation of gedit_view_new."""
    if 'gedit_view_new' in dummy:
        return dummy['gedit_view_new']
    else:
        raise NotImplementedError

def gedit_window_get_type():
    """A dummy implementation of gedit_window_get_type."""
    if 'gedit_window_get_type' in dummy:
        return dummy['gedit_window_get_type']
    else:
        raise NotImplementedError

def get_language_manager():
    """A dummy implementation of get_language_manager."""
    if 'get_language_manager' in dummy:
        return dummy['get_language_manager']
    else:
        raise NotImplementedError

def language_manager_list_languages_sorted(lm, include_hidden):
    """A dummy implementation of language_manager_list_languages_sorted."""
    if 'language_manager_list_languages_sorted' in dummy:
        return dummy['language_manager_list_languages_sorted']
    else:
        raise NotImplementedError

def language_manager_get_language_from_mime_type(lm, mime_type):
    """A dummy implementation of language_manager_get_language_from_mime_type."""
    if 'language_manager_get_language_from_mime_type' in dummy:
        return dummy['language_manager_get_language_from_mime_type']
    else:
        raise NotImplementedError

def app_get_default():
    """A fake implementation of app_get_default.

    Return a Gedit.App.
    """
    return App()



class App(GObject):
    """A dummy/fake implementation of App."""

    def get_lockdown(self):
        """A dummy implementation of get_lockdown."""
        key = '%s.get_lockdown' % self.__class__.__name__
        if key in dummy:
            return dummy[key]
        else:
            raise NotImplementedError

    def __new__(cls, *args, **kwargs):
        """Create a Singleton class."""
        if '_inst' not in vars(cls):
            cls._inst = super(App, cls).__new__(cls, *args, **kwargs)
        return cls._inst

    def get_active_window(self):
        """A fake implementation fo get_active_window."""
        key = '%s.get_active_window' % self.__class__.__name__
        if key in dummy:
            return dummy[key]
        for window in self.windows:
            if window.is_active():
                return window
        # No window is active, meaning that either there are no Gedit windows
        # or that no gedit windows are in the active window group.
        return self.active_window

    def get_documents(self):
        """A fake implementation fo get_views."""
        key = '%s.get_documents' % self.__class__.__name__
        if key in dummy:
            return dummy[key]
        documents = []
        for window in self.windows:
            documents.extend(window.get_documents())
        return documents

    def get_windows(self):
        """A fake implementation of get_windows."""
        key = '%s.get_windows' % self.__class__.__name__
        if key in dummy:
            return dummy[key]
        return self.windows

    def __init__(self):
        """A fake initialization of gedit.App."""
        super(App, self).__init__()
        self.windows = []
        self.active_window = None
        self.create_window()

    def create_window(self, screen=None):
        """A fake implementation of create_window."""
        key = '%s.create_window' % self.__class__.__name__
        if key in dummy:
            return dummy[key]
        window = Window()
        window.create_tab(True)
        self.windows.append(window)
        self.active_window = window
        return window

    def get_views(self):
        """A fake implementation fo get_views."""
        key = '%s.get_views' % self.__class__.__name__
        if key in dummy:
            return dummy[key]
        views = []
        for window in self.windows:
            views.extend(window.get_views())
        return views


class Document(gtksourceview2.Buffer):
    """A dummy/fake implementation of Document."""

    def get_short_name_for_display(self):
        """A dummy implementation of get_short_name_for_display."""
        key = '%s.get_short_name_for_display' % self.__class__.__name__
        if key in dummy:
            return dummy[key]
        else:
            raise NotImplementedError

    def get_readonly(self):
        """A dummy implementation of get_readonly."""
        key = '%s.get_readonly' % self.__class__.__name__
        if key in dummy:
            return dummy[key]
        else:
            raise NotImplementedError

    def insert_file(self, _iter, uri, encoding):
        """A dummy implementation of insert_file."""
        key = '%s.insert_file' % self.__class__.__name__
        if key in dummy:
            return dummy[key]
        else:
            raise NotImplementedError

    def load_cancel(self):
        """A dummy implementation of load_cancel."""
        key = '%s.load_cancel' % self.__class__.__name__
        if key in dummy:
            return dummy[key]
        else:
            raise NotImplementedError

    def save(self, flags):
        """A dummy implementation of save."""
        key = '%s.save' % self.__class__.__name__
        if key in dummy:
            return dummy[key]
        else:
            raise NotImplementedError

    def save_as(self, uri, encoding, flags):
        """A dummy implementation of save_as."""
        key = '%s.save_as' % self.__class__.__name__
        if key in dummy:
            return dummy[key]
        else:
            raise NotImplementedError

    def is_untouched(self):
        """A dummy implementation of is_untouched."""
        key = '%s.is_untouched' % self.__class__.__name__
        if key in dummy:
            return dummy[key]
        else:
            raise NotImplementedError

    def is_untitled(self):
        """A dummy implementation of is_untitled."""
        key = '%s.is_untitled' % self.__class__.__name__
        if key in dummy:
            return dummy[key]
        else:
            raise NotImplementedError

    def is_local(self):
        """A dummy implementation of is_local."""
        key = '%s.is_local' % self.__class__.__name__
        if key in dummy:
            return dummy[key]
        else:
            raise NotImplementedError

    def get_deleted(self):
        """A dummy implementation of get_deleted."""
        key = '%s.get_deleted' % self.__class__.__name__
        if key in dummy:
            return dummy[key]
        else:
            raise NotImplementedError

    def goto_line(self, line):
        """A dummy implementation of goto_line."""
        key = '%s.goto_line' % self.__class__.__name__
        if key in dummy:
            return dummy[key]
        else:
            raise NotImplementedError

    def set_search_text(self, text, flags):
        """A dummy implementation of set_search_text."""
        key = '%s.set_search_text' % self.__class__.__name__
        if key in dummy:
            return dummy[key]
        else:
            raise NotImplementedError

    def get_search_text(self, flags):
        """A dummy implementation of get_search_text."""
        key = '%s.get_search_text' % self.__class__.__name__
        if key in dummy:
            return dummy[key]
        else:
            raise NotImplementedError

    def get_can_search_again(self):
        """A dummy implementation of get_can_search_again."""
        key = '%s.get_can_search_again' % self.__class__.__name__
        if key in dummy:
            return dummy[key]
        else:
            raise NotImplementedError

    def search_forward(self, start, end, match_start, match_end):
        """A dummy implementation of search_forward."""
        key = '%s.search_forward' % self.__class__.__name__
        if key in dummy:
            return dummy[key]
        else:
            raise NotImplementedError

    def replace_all(self, find, replace, flags):
        """A dummy implementation of replace_all."""
        key = '%s.replace_all' % self.__class__.__name__
        if key in dummy:
            return dummy[key]
        else:
            raise NotImplementedError

    def search_backward(self, start, end, match_start, match_end):
        """A dummy implementation of search_backward."""
        key = '%s.search_backward' % self.__class__.__name__
        if key in dummy:
            return dummy[key]
        else:
            raise NotImplementedError

    def get_encoding(self):
        """A dummy implementation of get_encoding."""
        key = '%s.get_encoding' % self.__class__.__name__
        if key in dummy:
            return dummy[key]
        else:
            raise NotImplementedError

    def set_enable_search_highlighting(self, enable):
        """A dummy implementation of set_enable_search_highlighting."""
        key = '%s.set_enable_search_highlighting' % self.__class__.__name__
        if key in dummy:
            return dummy[key]
        else:
            raise NotImplementedError

    def get_enable_search_highlighting(self):
        """A dummy implementation of get_enable_search_highlighting."""
        key = '%s.get_enable_search_highlighting' % self.__class__.__name__
        if key in dummy:
            return dummy[key]
        else:
            raise NotImplementedError

    def load(self, uri, encoding, line_pos, create):
        """A fake implementation of load.

        The encoding, line_pos, and create args are ignored.
        The uri must use the file:// protocol.
        """
        key = '%s.load' % self.__class__.__name__
        if key in dummy:
            return
        from mimetypes import MimeTypes
        from urllib import urlopen
        try:
            source_file = urlopen(uri)
            text = ''.join(source_file.readlines())
        except IOError:
            raise ValueError(u'%s cannot be read' % uri)
        else:
            source_file.close()
        self.set_text(text, -1)
        self.uri = uri
        self.encoding = encoding
        mt = MimeTypes()
        mime_type, encoding = mt.guess_type(uri)
        lang_id = self._mime_types.get(mime_type, None)

        class Language:

            def __init__(self, lang_id):
                self.id = lang_id

            def get_id(self):
                return self.id

        if lang_id is None:
            language = None
        else:
            language = Language(lang_id)
        self.set_language(language)

    def get_language(self):
        """A fake implementation of get_language."""
        key = '%s.get_language' % self.__class__.__name__
        if key in dummy:
            return dummy[key]
        return self.language

    def get_uri_for_display(self):
        """A fake implementation of get_uri_for_display."""
        key = '%s.get_uri_for_display' % self.__class__.__name__
        if key in dummy:
            return dummy[key]
        if self.uri.startswith('file:'):
            from urllib import url2pathname
            return url2pathname(self.uri[7:])
        else:
            return self.uri

    def get_uri(self):
        """A fake implementation of get_uri."""
        key = '%s.get_uri' % self.__class__.__name__
        if key in dummy:
            return dummy[key]
        return self.uri

    def get_mime_type(self):
        """A fake implementation of get_mime_type."""
        key = '%s.get_mime_type' % self.__class__.__name__
        if key in dummy:
            return dummy[key]
        elif self.language:
            mime_types = self.language.get_mime_types()
            if mime_types:
                return mime_types[0]
        else:
            # There is no information about the mime-type.
            pass
        return 'text/plain'

    def set_language(self, val):
        """A fake implementation of set_language."""
        key = '%s.set_language' % self.__class__.__name__
        if key in dummy:
            dummy[key] = val
            return
        self.language = val

    def __init__(self):
        """A fake initialization of gedit.Document."""
        super(Document, self).__init__()
        self.uri = None
        self.encoding = None
        self.language = None
        self._mime_types = {
            'text/x-python': 'python',
            'text/x-python-doctest': 'doctest',
            'text/css': 'css',
            'text/html': 'html',
            'application/javascript': 'js',
            'application/xml': 'xml',
            'application/x-sh': 'sh',
            'application/x-zope-configuation': 'xml',
            'application/x-zope-page-template': 'html',
            }


class Panel(gtk.VBox):
    """A dummy/fake implementation of Panel."""

    def add_item(self, item, name, image):
        """A dummy implementation of add_item."""
        key = '%s.add_item' % self.__class__.__name__
        if key in dummy:
            return dummy[key]
        else:
            raise NotImplementedError

    def add_item_with_stock_icon(self, item, name, stock_id):
        """A dummy implementation of add_item_with_stock_icon."""
        key = '%s.add_item_with_stock_icon' % self.__class__.__name__
        if key in dummy:
            return dummy[key]
        else:
            raise NotImplementedError

    def remove_item(self, item):
        """A dummy implementation of remove_item."""
        key = '%s.remove_item' % self.__class__.__name__
        if key in dummy:
            return dummy[key]
        else:
            raise NotImplementedError

    def activate_item(self, item):
        """A dummy implementation of activate_item."""
        key = '%s.activate_item' % self.__class__.__name__
        if key in dummy:
            return dummy[key]
        else:
            raise NotImplementedError

    def item_is_active(self, item):
        """A dummy implementation of item_is_active."""
        key = '%s.item_is_active' % self.__class__.__name__
        if key in dummy:
            return dummy[key]
        else:
            raise NotImplementedError

    def get_orientation(self):
        """A dummy implementation of get_orientation."""
        key = '%s.get_orientation' % self.__class__.__name__
        if key in dummy:
            return dummy[key]
        else:
            raise NotImplementedError

    def get_n_items(self):
        """A dummy implementation of get_n_items."""
        key = '%s.get_n_items' % self.__class__.__name__
        if key in dummy:
            return dummy[key]
        else:
            raise NotImplementedError


class Plugin(GObject):
    """A dummy/fake implementation of Plugin."""

    def activate(self, window):
        """A dummy implementation of activate."""
        key = '%s.activate' % self.__class__.__name__
        if key in dummy:
            return dummy[key]
        else:
            raise NotImplementedError

    def deactivate(self, window):
        """A dummy implementation of deactivate."""
        key = '%s.deactivate' % self.__class__.__name__
        if key in dummy:
            return dummy[key]
        else:
            raise NotImplementedError

    def update_ui(self, window):
        """A dummy implementation of update_ui."""
        key = '%s.update_ui' % self.__class__.__name__
        if key in dummy:
            return dummy[key]
        else:
            raise NotImplementedError

    def is_configurable(self):
        """A dummy implementation of is_configurable."""
        key = '%s.is_configurable' % self.__class__.__name__
        if key in dummy:
            return dummy[key]
        else:
            raise NotImplementedError

    def create_configure_dialog(self):
        """A dummy implementation of create_configure_dialog."""
        key = '%s.create_configure_dialog' % self.__class__.__name__
        if key in dummy:
            return dummy[key]
        else:
            raise NotImplementedError


class Statusbar(gtk.Statusbar):
    """A dummy/fake implementation of Statusbar."""

    def flash_message(self, context_id, message):
        """A dummy implementation of flash_message."""
        key = '%s.flash_message' % self.__class__.__name__
        if key in dummy:
            return dummy[key]
        else:
            raise NotImplementedError


class Tab(gtk.VBox):
    """A dummy/fake implementation of Tab."""

    def get_state(self):
        """A dummy implementation of get_state."""
        key = '%s.get_state' % self.__class__.__name__
        if key in dummy:
            return dummy[key]
        else:
            raise NotImplementedError

    def set_auto_save_enabled(self, enable):
        """A dummy implementation of set_auto_save_enabled."""
        key = '%s.set_auto_save_enabled' % self.__class__.__name__
        if key in dummy:
            return dummy[key]
        else:
            raise NotImplementedError

    def get_auto_save_enabled(self):
        """A dummy implementation of get_auto_save_enabled."""
        key = '%s.get_auto_save_enabled' % self.__class__.__name__
        if key in dummy:
            return dummy[key]
        else:
            raise NotImplementedError

    def set_auto_save_interval(self, interval):
        """A dummy implementation of set_auto_save_interval."""
        key = '%s.set_auto_save_interval' % self.__class__.__name__
        if key in dummy:
            return dummy[key]
        else:
            raise NotImplementedError

    def get_auto_save_interval(self):
        """A dummy implementation of get_auto_save_interval."""
        key = '%s.get_auto_save_interval' % self.__class__.__name__
        if key in dummy:
            return dummy[key]
        else:
            raise NotImplementedError

    def get_document(self):
        """A fake implementation of get_document."""
        key = '%s.get_document' % self.__class__.__name__
        if key in dummy:
            return dummy[key]
        view = self.get_view()
        if view:
            return view.get_buffer()
        return None

    def get_view(self):
        """A fake implementation of get_view."""
        key = '%s.get_view' % self.__class__.__name__
        if key in dummy:
            return dummy[key]
        children = self.get_children()
        if children:
            # vbox[scrolledwindow].viewport.view
            return children[0].get_child().get_child()
        return None

    def __init__(self):
        """A fake initialization of gedit.Tab."""
        super(Tab, self).__init__()


class View(gtksourceview2.View):
    """A dummy/fake implementation of View."""

    def cut_clipboard(self):
        """A dummy implementation of cut_clipboard."""
        key = '%s.cut_clipboard' % self.__class__.__name__
        if key in dummy:
            return dummy[key]
        else:
            raise NotImplementedError

    def copy_clipboard(self):
        """A dummy implementation of copy_clipboard."""
        key = '%s.copy_clipboard' % self.__class__.__name__
        if key in dummy:
            return dummy[key]
        else:
            raise NotImplementedError

    def paste_clipboard(self):
        """A dummy implementation of paste_clipboard."""
        key = '%s.paste_clipboard' % self.__class__.__name__
        if key in dummy:
            return dummy[key]
        else:
            raise NotImplementedError

    def delete_selection(self):
        """A dummy implementation of delete_selection."""
        key = '%s.delete_selection' % self.__class__.__name__
        if key in dummy:
            return dummy[key]
        else:
            raise NotImplementedError

    def select_all(self):
        """A dummy implementation of select_all."""
        key = '%s.select_all' % self.__class__.__name__
        if key in dummy:
            return dummy[key]
        else:
            raise NotImplementedError

    def scroll_to_cursor(self):
        """A dummy implementation of scroll_to_cursor."""
        key = '%s.scroll_to_cursor' % self.__class__.__name__
        if key in dummy:
            return dummy[key]
        else:
            raise NotImplementedError

    def set_font(self, _def, font_name):
        """A dummy implementation of set_font."""
        key = '%s.set_font' % self.__class__.__name__
        if key in dummy:
            return dummy[key]
        else:
            raise NotImplementedError

    def get_window(self, win):
        """Return the real or dummy gdk.window.

        When View.get_window is a key in dummy, a testing value is returned,
        other the real window is returned.
        """
        key = '%s.get_window' % self.__class__.__name__
        if key in dummy:
            return dummy[key]
        return super(View, self).get_window(win)

    def __init__(self, document=None):
        """A fake initialization of gedit.View."""
        if not document:
            document = Document()
        super(View, self).__init__(document)


class Window(gtk.Window):
    """A dummy/fake implementation of Window."""

    def close_tab(self, tab):
        """A dummy implementation of close_tab."""
        key = '%s.close_tab' % self.__class__.__name__
        if key in dummy:
            return dummy[key]
        else:
            raise NotImplementedError

    def close_tabs(self, tabs):
        """A dummy implementation of close_tabs."""
        key = '%s.close_tabs' % self.__class__.__name__
        if key in dummy:
            return dummy[key]
        else:
            raise NotImplementedError

    def close_all_tabs(self):
        """A dummy implementation of close_all_tabs."""
        key = '%s.close_all_tabs' % self.__class__.__name__
        if key in dummy:
            return dummy[key]
        else:
            raise NotImplementedError

    def get_unsaved_documents(self):
        """A dummy implementation of get_unsaved_documents."""
        key = '%s.get_unsaved_documents' % self.__class__.__name__
        if key in dummy:
            return dummy[key]
        else:
            raise NotImplementedError

    def get_statusbar(self):
        """A dummy implementation of get_statusbar."""
        key = '%s.get_statusbar' % self.__class__.__name__
        if key in dummy:
            return dummy[key]
        else:
            raise NotImplementedError

    def get_state(self):
        """A dummy implementation of get_state."""
        key = '%s.get_state' % self.__class__.__name__
        if key in dummy:
            return dummy[key]
        else:
            raise NotImplementedError

    def get_tab_from_uri(self, uri):
        """A dummy implementation of get_tab_from_uri."""
        key = '%s.get_tab_from_uri' % self.__class__.__name__
        if key in dummy:
            return dummy[key]
        else:
            raise NotImplementedError

    def create_tab(self, jump_to):
        """A fake implementation of create_tab."""
        key = '%s.create_tab' % self.__class__.__name__
        if key in dummy:
            return
        self.create_tab_from_uri(None, None, 0, True, jump_to)

    def create_tab_from_uri(self, uri, encoding, line_pos, create, jump_to):
        """A fake implementation of create_tab_from_uri."""
        key = '%s.create_tab_from_uri' % self.__class__.__name__
        if key in dummy:
            return
        document = Document()
        tab_label = gtk.Label('Untitled')
        if uri:
            from os.path import basename
            document.load(uri, encoding, line_pos, create)
            tab_label = gtk.Label(basename(document.get_uri_for_display()))
        view = View(document)
        scrolled_win = gtk.ScrolledWindow()
        scrolled_win.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
        scrolled_win.add_with_viewport(view)
        tab = Tab()
        tab.pack_start(scrolled_win)
        n = self.get_child().append_page(tab, tab_label)
        tab.show_all()
        if n == 0 or jump_to:
            self.get_child().set_current_page(n)
        self.emit('tab-added', tab)

    def get_active_tab(self):
        """A fake implementation of get_active_tab."""
        key = '%s.get_active_tab' % self.__class__.__name__
        if key in dummy:
            return dummy[key]
        n = self.get_child().get_current_page()
        return self.get_child().get_nth_page(n)

    def get_group(self):
        """A fake initialization of gedit.Window.get_group."""
        key = '%s.get_group' % self.__class__.__name__
        if key in dummy:
            return dummy[key]
        return gtk.WindowGroup()

    def get_side_panel(self):
        """A fake bottom panel."""
        class FakePanel:
            def __init__(self):
                self.widget = None
                self.label = None
                self.icon = None

            def add_item(self, widget, label, icon):
                self.widget = widget
                self.label = label
                self.icon = icon

            def remove_item(self, widget):
                self.widget = None
                self.label = None
                self.icon = None

        return FakePanel()

    def get_active_document(self):
        """A fake implementation of get_active_document."""
        key = '%s.get_active_document' % self.__class__.__name__
        if key in dummy:
            return dummy[key]
        tab = self.get_active_tab()
        return tab.get_document()

    def get_documents(self):
        """A fake implementation of get_documents."""
        key = '%s.get_views' % self.__class__.__name__
        if key in dummy:
            return dummy[key]
        return [tab.get_document() for tab in self.tabs_]

    def get_bottom_panel(self):
        """A fake bottom panel."""
        class FakePanel:
            def __init__(self):
                self.widget = None
                self.label = None
                self.icon = None

            def add_item(self, widget, label, icon):
                self.widget = widget
                self.label = label
                self.icon = icon

            def remove_item(self, widget):
                self.widget = None
                self.label = None
                self.icon = None

        return FakePanel()

    def set_active_tab(self, tab):
        """A fake implementation of set_active_tab."""
        key = '%s.set_active_tab' % self.__class__.__name__
        if key in dummy:
            dummy[key] = tab
            return
        n = self.get_child().page_num(tab)
        self.get_child().set_current_page(n)

    def get_views(self):
        """A fake implementation of get_views."""
        key = '%s.get_views' % self.__class__.__name__
        if key in dummy:
            return dummy[key]
        return [tab.get_view() for tab in self.tabs_]

    def get_active_view(self):
        """A fake implementation of get_active_view."""
        key = '%s.get_active_view' % self.__class__.__name__
        if key in dummy:
            return dummy[key]
        tab = self.get_active_tab()
        return tab.get_view()

    @property
    def tabs_(self):
        """A testing property to access all tabs (do not use)."""
        n_pages = self.get_child().get_n_pages()
        tabs = []
        for n in range(0, n_pages):
            tabs.append(self.get_child().get_nth_page(n))
        return tabs

    def get_ui_manager(self):
        """A fake initialization of gedit.Window.get_ui_manager."""
        return self.ui_manager

    def __init__(self):
        """A fake initialization of gedit.Window."""
        super(Window, self).__init__()
        self.add(gtk.Notebook())
        self.connect("destroy", gtk.main_quit)
        self.resize(300, 250)
        self.action_group = gtk.ActionGroup(name='GeditMenu')
        self.action_group.add_actions([
            ('Tools', None, _('_Tools'), None, None, None)])
        self.ui_manager = gtk.UIManager()
        self.ui_manager.insert_action_group(self.action_group, -1)
        menu_xml = """
            <ui>
              <menubar name="MenuBar">
                <menu name='ToolsMenu' action='Tools' />
              </menubar>
            </ui>
            """
        self.ui_id = self.ui_manager.add_ui_from_string(menu_xml)


#line 428 "gedit.overrides"
# The Gedit python environment has gettext builtin
__builtin__.__dict__['_'] = gettext


gobject.signal_new(
    'tab-added', Window, gobject.SIGNAL_RUN_LAST,
    gobject.TYPE_NONE, (gobject.TYPE_PYOBJECT,))


