/* -*- mode: C++; c-basic-offset: 2; indent-tabs-mode: nil -*- */
/*
 *  Main authors:
 *     Guido Tack <tack@gecode.org>
 *     Christian Schulte <schulte@gecode.org>
 *
 *  Copyright:
 *     Guido Tack, 2004
 *     Christian Schulte, 2004
 *
 *  Last modified:
 *     $Date: 2009-03-02 10:08:11 +0100 (Mon, 02 Mar 2009) $ by $Author: schulte $
 *     $Revision: 8320 $
 *
 *  This file is part of Gecode, the generic constraint
 *  development environment:
 *     http://www.gecode.org
 *
 *  Permission is hereby granted, free of charge, to any person obtaining
 *  a copy of this software and associated documentation files (the
 *  "Software"), to deal in the Software without restriction, including
 *  without limitation the rights to use, copy, modify, merge, publish,
 *  distribute, sublicense, and/or sell copies of the Software, and to
 *  permit persons to whom the Software is furnished to do so, subject to
 *  the following conditions:
 *
 *  The above copyright notice and this permission notice shall be
 *  included in all copies or substantial portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 *  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 *  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 *  NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 *  LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 *  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 *  WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 */

#include <gecode/set/element.hh>

namespace Gecode {

  namespace Int { namespace Element {
    template<>
    class ViewToVarArg<Gecode::Set::ConstantView> {
    public:
      typedef IntSetArgs argtype;
    };
  }}

  using namespace Gecode::Set;

  void
  element(Space& home, SetOpType op, const SetVarArgs& x, SetVar y, SetVar z,
    const IntSet& universe) {
    if (home.failed()) return;
    
    switch (op) {
    case SOT_DUNION:
      {
        Set::Element::ElementDisjoint<SetView,SetView>::IdxViewArray
          iv(home, x);
        GECODE_ES_FAIL(home,(Element::ElementDisjoint<SetView,SetView>::
                        post(home,iv,y)));
      }
      // fall through
    case SOT_UNION:
      {
        Set::Element::ElementUnion<SetView,SetView>::IdxViewArray iv(home, x);
        GECODE_ES_FAIL(home,
                       (Element::ElementUnion<SetView,SetView>::
                        post(home,z,iv,y)));
      }
      break;
    case SOT_INTER:
      {
        Set::Element::ElementIntersection<SetView,SetView>::IdxViewArray
          iv(home, x);
        GECODE_ES_FAIL(home,
                       (Element::ElementIntersection<SetView,SetView>::
                        post(home,z,iv,y,universe)));
      }
      break;
    case SOT_MINUS:
      throw IllegalOperation("Set::element");
      break;
    default:
      throw UnknownOperation("Set::element");
    }
  }

  void
  element(Space& home, SetOpType op, const IntSetArgs& x, SetVar y, SetVar z,
    const IntSet& universe) {
    if (home.failed()) return;

    switch (op) {
    case SOT_DUNION:
      {
        Set::Element::ElementDisjoint<ConstantView,SetView>::IdxViewArray
          iv(home, x.size());
        for (int i=x.size(); i--;) {
          iv[i].idx = i; iv[i].view = ConstantView(home, x[i]);
        }
        GECODE_ES_FAIL(home,(Element::ElementDisjoint<ConstantView,SetView>::
                        post(home,iv,y)));
      }
      // fall through
    case SOT_UNION:
      {
        SharedArray<IntSet> s(x.size());
        for (int i=s.size(); i--;)
          new (&s[i]) IntSet(x[i]);
        GECODE_ES_FAIL(home,
                       (Element::ElementUnionConst<SetView,SetView>::
                        post(home,z,s,y)));
      }
      break;
    case SOT_INTER:
      {
        Set::Element::ElementIntersection<ConstantView,SetView>::IdxViewArray
          iv(home, x.size());
        for (int i=x.size(); i--;) {
          iv[i].idx = i; iv[i].view = ConstantView(home, x[i]);
        }
        GECODE_ES_FAIL(home,
                       (Element::ElementIntersection<ConstantView,SetView>::
                        post(home,z,iv,y,universe)));
      }
      break;
    case SOT_MINUS:
      throw IllegalOperation("Set::element");
      break;
    default:
      throw UnknownOperation("Set::element");
    }
    
  }

  void
  element(Space& home, const SetVarArgs& x, IntVar y, SetVar z) {
    if (home.failed()) return;
    Set::Element::ElementUnion<SetView,SingletonView>::IdxViewArray iv(home, x);
    SetView zv(z);

    Int::IntView yv(y);
    SingletonView single(yv);
    GECODE_ES_FAIL(home,(Element::ElementUnion<SetView,
                         SingletonView>::post(home, z, iv, single)));
  }

  void
  element(Space& home, const IntSetArgs& s, IntVar y, SetVar z) {
    for (int i=s.size(); i--;)
      Set::Limits::check(s[i], "Set::element");
    if (home.failed()) return;
    SetView zv(z);
    SharedArray<IntSet> x(s.size());
    for (int i=s.size(); i--;)
      new (&x[i]) IntSet(s[i]);

    Int::IntView yv(y);
    SingletonView single(yv);
    GECODE_ES_FAIL(home,(Element::ElementUnionConst<SetView,
                         SingletonView>::post(home, z, x, single)));
  }

}

// STATISTICS: set-post

