#
#  Main authors:
#     Christian Schulte <schulte@gecode.org>
#
#  Copyright:
#     Christian Schulte, 2008
#
#  Last modified:
#     $Date: 2008-01-23 09:51:06 +0100 (Wed, 23 Jan 2008) $ by $Author: tack $
#     $Revision: 5949 $
#
#  This file is part of Gecode, the generic constraint
#  development environment:
#     http://www.gecode.org
#
#  Permission is hereby granted, free of charge, to any person obtaining
#  a copy of this software and associated documentation files (the
#  "Software"), to deal in the Software without restriction, including
#  without limitation the rights to use, copy, modify, merge, publish,
#  distribute, sublicense, and/or sell copies of the Software, and to
#  permit persons to whom the Software is furnished to do so, subject to
#  the following conditions:
#
#  The above copyright notice and this permission notice shall be
#  included in all copies or substantial portions of the Software.
#
#  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
#  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
#  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
#  NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
#  LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
#  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
#  WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
#

[Header]

[Footer]

// STATISTICS: int-branch

[General]
# Type of view
View:		IntView
# Type of variable argument
VarArgs:	IntVarArgs
# Type of variable branching selection
VarBranch:	IntVarBranch
# Type of value branch selection
ValBranch:	IntValBranch
# Exception to be thrown if variable branch selection unknown
Exception:	UnknownBranching("Int::branch")
# Header file to include
Include:	<gecode/int/branch.hh>
# Local namespace
LNS:		Gecode::Int::Branch
# Global namespace
GNS:		Gecode
[VarBranch]
# Value for branching selection, mark as special
Value:		INT_VAR_NONE = NONE
# Corresponding type
Type:		ViewSelNone<IntView>
[VarBranch]
Value:		INT_VAR_RND = COMPLETE
Type:		ViewSelRnd<IntView>
[VarBranch]
Value:		INT_VAR_MIN_MIN
Type:		ByMinMin
[VarBranch]
Value:		INT_VAR_MIN_MAX
Type:		ByMinMax
[VarBranch]
Value:		INT_VAR_MAX_MIN
Type:		ByMaxMin
[VarBranch]
Value:		INT_VAR_MAX_MAX
Type:		ByMaxMax
[VarBranch]
Value:		INT_VAR_SIZE_MIN
Type:		BySizeMin
[VarBranch]
Value:		INT_VAR_SIZE_MAX
Type:		BySizeMax
[VarBranch]
Value:		INT_VAR_DEGREE_MIN
Type:		ViewSelDegreeMin<IntView>
[VarBranch]
Value:		INT_VAR_DEGREE_MAX
Type:		ViewSelDegreeMax<IntView>
[VarBranch]
Value:		INT_VAR_SIZE_DEGREE_MIN
Type:		BySizeDegreeMin
[VarBranch]
Value:		INT_VAR_SIZE_DEGREE_MAX
Type:		BySizeDegreeMax
[VarBranch]
Value:		INT_VAR_REGRET_MIN_MIN
Type:		ByRegretMinMin
[VarBranch]
Value:		INT_VAR_REGRET_MIN_MAX
Type:		ByRegretMinMax
[VarBranch]
Value:		INT_VAR_REGRET_MAX_MIN
Type:		ByRegretMaxMin
[VarBranch]
Value:		INT_VAR_REGRET_MAX_MAX
Type:		ByRegretMaxMax
[End]
