!-------------------------------------------------------------------------------

!     This file is part of the Code_Saturne Kernel, element of the
!     Code_Saturne CFD tool.

!     Copyright (C) 1998-2009 EDF S.A., France

!     contact: saturne-support@edf.fr

!     The Code_Saturne Kernel is free software; you can redistribute it
!     and/or modify it under the terms of the GNU General Public License
!     as published by the Free Software Foundation; either version 2 of
!     the License, or (at your option) any later version.

!     The Code_Saturne Kernel is distributed in the hope that it will be
!     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
!     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!     GNU General Public License for more details.

!     You should have received a copy of the GNU General Public License
!     along with the Code_Saturne Kernel; if not, write to the
!     Free Software Foundation, Inc.,
!     51 Franklin St, Fifth Floor,
!     Boston, MA  02110-1301  USA

!-------------------------------------------------------------------------------

subroutine haltyp &
!================

 ( ivoset )

!===============================================================================
! FONCTION :
! ---------

! TEST DE LA NECESSITE DU VOISINAGE ETENDU, POUR ENVOI AU C
!-------------------------------------------------------------------------------
! Arguments
!__________________.____._____.________________________________________________.
! name             !type!mode ! role                                           !
!__________________!____!_____!________________________________________________!
! ivoset           ! e  ! <-- ! indicateur d'activation du vois. et.           !
!__________________!____!_____!________________________________________________!

!     TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
!            L (LOGIQUE)   .. ET TYPES COMPOSES (EX : TR TABLEAU REEL)
!     MODE : <-- donnee, --> resultat, <-> Donnee modifiee
!            --- tableau de travail
!===============================================================================

implicit none

!===============================================================================
! Common blocks
!===============================================================================

include "dimens.h"
include "paramx.h"
include "cstphy.h"
include "optcal.h"
include "ppppar.h"
include "ppthch.h"
include "ppincl.h"

! Arguments

integer          ii, ivoset


!===============================================================================

ivoset = 0

if (imrgra.eq.2 .or. imrgra.eq.3) ivoset = 1

do ii = 1, nphsmx
  if (iturb(ii).eq.41) ivoset = 1
enddo

if (ippmod(iaeros).ge.0) ivoset = 1

return
end subroutine
