/* imgtest.c - part of ziproxy.c
 * 2002 Juraj Variny <variny@naex.sk>
 *
 * Released subject to GNU General Public License v2 or later version.
 * Test utility for image compression.
*/
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include "cfgfile.h"
#include "image.h"
#include "http.h"

int main(int argc, char **argv)
{
	FILE *infile, *outfile;
	int inlen, outlen = 0;
	char *inbuf,  *outbuf;
	http_headers *hdr;

    	ReadCfgFile(DefaultCfgLocation);
	ModifySuffixes = 0;
	
	if (argc != 3) {
		fputs("Usage: imgtest file1 file2\n\n"

		"It will convert file1 from GIF, PNG or JPEG to \n"
		"low quality JPEG,JP2 or PNG named file2.\n"
		"Image compression behaves exactly as ziproxy,\n"
		"according to ziproxy.conf in current directory.\n "
		"If file2 would not be smaller than file1 (image \n"
		"could or should not be compressed), image is\n"
		"only copied.\n", stderr);
		return 1;
	}
	
	infile = fopen(argv[1],"rb");
	outfile = fopen(argv[2], "w+b");

	if ((infile == NULL) || (outfile == NULL)) return 2;

	fseek(infile, 0, SEEK_END);
	inlen = ftell(infile);
	rewind(infile);

	inbuf = malloc(inlen);
	fread(inbuf, inlen, 1, infile);
	
	fclose(infile);
	hdr = (http_headers*)malloc(sizeof(http_headers)); //fake headers for compress_image
	hdr->lines = 0;
	hdr->image = IMG_GIF; //it should detect proper image type
	hdr->flags = H_SIMPLE_RESPONSE;
	hdr->where_content_type = -1;
	if(compress_image(hdr, hdr, inbuf, inlen, &outbuf, &outlen)) {
		outbuf=inbuf;
		outlen=inlen;
	}
		
	if(fwrite(outbuf, 1, outlen, outfile) != outlen) return 5;

	return 0;
}

