/* cfgtest.c
 * Part of ziproxy package.
 * 
 * 2003 Juraj Variny<variny@naex.sk>
 *
 * Released subject to GNU General Public License v2 or later version.
 * 
 * Parses the configuration file and prints values of all options to standard 
 * output.
 */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <string.h>

#include "cfgfile.h"

int main(int argc, char **argv)
{
	char *cfg_file;
	int status, i;
		
	if((argc != 1) && (argc != 3)) return 1;
	else if(argc == 3) 
	{
		if(!strncmp(argv[1], "-c", 2))
			cfg_file = argv[2];
		else {
			fputs("Usage: cfgtest [/location/of/ziproxy.conf]\n", stderr);
			return 2;
		}

	}else cfg_file=DefaultCfgLocation;
	
	status = ReadCfgFile(cfg_file);
	if(status == -1)
		fprintf(stderr, "File '%s' not found! Using default values.\n", cfg_file);
	
	printf("where ziproxy: %s\n", WhereZiproxy);
	printf("server_name: %s\n", ServHost);
	printf("server_url: %s\n", ServUrl);
        printf("Port: %d\n", Port);
	printf("OnlyFrom: %s\n", OnlyFrom);
	printf("logfile name: %s\n", LogFileName);
	
	i=0;
	fputs("LogPipe:", stdout);
	if(LogPipe)
		while(LogPipe[i]){
			if(i) fputs(", ", stdout);
			putc('"', stdout);
			fputs(LogPipe[i], stdout);
			putc('"', stdout);
			i++;
		}
	else fputs("(null)", stdout);	

	fputs("\nCompressible:", stdout);
	if(Compressible)
		while(Compressible[i]){
			if(i) fputs(", ", stdout);
			putc('"', stdout);
			fputs(Compressible[i], stdout);
			putc('"', stdout);
			i++;
		}
	else fputs("(null)", stdout);	

	printf("\nNextProxy: %s\n", NextProxy);
        printf("NextPort: %d\n", NextPort);
	printf("netd timeout: %ds\n", NetdTimeout);
	printf("ziproxy timeout: %ds\n", ZTimeout);
	printf("MSIETest: %s\n",MSIETest ? "true" : "false");
	printf("gzip: %s\n",DoGzip ? "true" : "false");
	printf("Does suffix modification: %s\n",ModifySuffixes ? "true" : "false");
	printf("use content length: %s\n", UseContentLength ? "true" : "false");
	printf("MaxSize: %d (%d kB)\n", MaxSize, MaxSize/1024);
        printf("JPEG thumb, small, med, large qualities: %d, %d, %d, %d\n", 
			ThumbQ, SmallQ, MedQ, LargeQ);
	printf("Allow look change: %s\n", AllowLookCh ? "true" : "false");
	printf("Comression rates for JPEG2000s: %f, %f, %f, %f\n",
			ThumbRate, SmallRate, MedRate, LargeRate);

	return 0;
}
