/*
 * Decompiled with CFR 0.152.
 */
package IceGridGUI.Application;

import IceGrid.NodeDescriptor;
import IceGridGUI.Application.Editable;
import IceGridGUI.Application.Editor;
import IceGridGUI.Application.MapField;
import IceGridGUI.Application.Node;
import IceGridGUI.Application.Nodes;
import IceGridGUI.Application.Root;
import IceGridGUI.Application.UpdateFailedException;
import IceGridGUI.Utils;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import java.awt.Component;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

class NodeEditor
extends Editor {
    private JTextField _name = new JTextField(20);
    private JTextArea _description = new JTextArea(3, 20);
    private MapField _variables;
    private JTextField _loadFactor = new JTextField(20);
    static final /* synthetic */ boolean $assertionsDisabled;

    protected void buildPropertiesPanel() {
        super.buildPropertiesPanel();
        this._propertiesPanel.setName("Node Properties");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean applyUpdate(boolean refresh) {
        Root root = this._target.getRoot();
        root.disableSelectionListener();
        try {
            if (this._target.isEphemeral()) {
                Nodes nodes = (Nodes)this._target.getParent();
                this.writeDescriptor();
                NodeDescriptor descriptor = (NodeDescriptor)this._target.getDescriptor();
                this._target.destroy();
                try {
                    nodes.tryAdd(this._name.getText().trim(), descriptor);
                }
                catch (UpdateFailedException e) {
                    block18: {
                        try {
                            nodes.insertChild(this._target, true);
                        }
                        catch (UpdateFailedException die) {
                            if ($assertionsDisabled) break block18;
                            throw new AssertionError();
                        }
                    }
                    root.setSelectedNode(this._target);
                    JOptionPane.showMessageDialog(root.getCoordinator().getMainFrame(), e.toString(), "Apply failed", 0);
                    boolean die = false;
                    root.enableSelectionListener();
                    return die;
                }
                this._target = nodes.findChildWithDescriptor(descriptor);
                root.updated();
                if (refresh) {
                    root.setSelectedNode(this._target);
                }
            } else if (this.isSimpleUpdate()) {
                this.writeDescriptor();
                root.updated();
                ((Node)this._target).getEditable().markModified();
            } else {
                NodeDescriptor savedDescriptor = ((Node)this._target).saveDescriptor();
                this.writeDescriptor();
                LinkedList editables = new LinkedList();
                try {
                    ((Node)this._target).rebuild(editables);
                }
                catch (UpdateFailedException e) {
                    ((Node)this._target).restoreDescriptor(savedDescriptor);
                    JOptionPane.showMessageDialog(root.getCoordinator().getMainFrame(), e.toString(), "Apply failed", 0);
                    boolean die = false;
                    root.enableSelectionListener();
                    return die;
                }
                Iterator p = editables.iterator();
                while (p.hasNext()) {
                    Editable editable = (Editable)p.next();
                    editable.markModified();
                }
                ((Node)this._target).getEditable().markModified();
                root.updated();
            }
            if (refresh) {
                root.getCoordinator().getCurrentTab().showNode(this._target);
            }
            this._applyButton.setEnabled(false);
            this._discardButton.setEnabled(false);
            boolean bl = true;
            return bl;
        }
        finally {
            root.enableSelectionListener();
        }
    }

    Utils.Resolver getDetailResolver() {
        if (this._target.getCoordinator().substitute()) {
            return this._target.getResolver();
        }
        return null;
    }

    NodeEditor() {
        this._name.getDocument().addDocumentListener(this._updateListener);
        this._name.setToolTipText("Must match the IceGrid.Node.Name property of the desired icegridnode process");
        this._description.getDocument().addDocumentListener(this._updateListener);
        this._description.setToolTipText("An optional description for this node");
        this._variables = new MapField((Editor)this, "Name", "Value", false);
        this._loadFactor.getDocument().addDocumentListener(this._updateListener);
        this._loadFactor.setToolTipText("<html>A floating point value.<br>When not specified, IceGrid uses 1.0 on all platforms<br>except Windows where it uses 1.0 divided by <i>number of processors</i>.<html>");
    }

    protected void appendProperties(DefaultFormBuilder builder) {
        builder.append("Name");
        builder.append((Component)this._name, 3);
        builder.nextLine();
        builder.append("Description");
        builder.nextLine();
        builder.append("");
        builder.nextRow(-2);
        CellConstraints cc = new CellConstraints();
        JScrollPane scrollPane = new JScrollPane(this._description);
        builder.add(scrollPane, cc.xywh(builder.getColumn(), builder.getRow(), 3, 3));
        builder.nextRow(2);
        builder.nextLine();
        builder.append("Variables");
        builder.nextLine();
        builder.append("");
        builder.nextLine();
        builder.append("");
        builder.nextLine();
        builder.append("");
        builder.nextRow(-6);
        scrollPane = new JScrollPane(this._variables);
        builder.add(scrollPane, cc.xywh(builder.getColumn(), builder.getRow(), 3, 7));
        builder.nextRow(6);
        builder.nextLine();
        builder.append("Load Factor");
        builder.append((Component)this._loadFactor, 3);
        builder.nextLine();
    }

    boolean isSimpleUpdate() {
        NodeDescriptor descriptor = (NodeDescriptor)this._target.getDescriptor();
        return this._variables.get().equals(descriptor.variables);
    }

    void writeDescriptor() {
        NodeDescriptor descriptor = (NodeDescriptor)this._target.getDescriptor();
        descriptor.description = this._description.getText();
        descriptor.variables = this._variables.get();
        descriptor.loadFactor = this._loadFactor.getText().trim();
    }

    protected boolean validate() {
        return this.check(new String[]{"Name", this._name.getText().trim()});
    }

    void show(Node node) {
        this.detectUpdates(false);
        this._target = node;
        Utils.Resolver resolver = this.getDetailResolver();
        boolean isEditable = resolver == null;
        this._name.setText(this._target.getId());
        this._name.setEditable(this._target.isEphemeral());
        NodeDescriptor descriptor = (NodeDescriptor)this._target.getDescriptor();
        this._description.setText(Utils.substitute(descriptor.description, resolver));
        this._description.setEditable(isEditable);
        this._description.setOpaque(isEditable);
        this._variables.set(descriptor.variables, resolver, isEditable);
        this._loadFactor.setText(Utils.substitute(descriptor.loadFactor, resolver));
        this._loadFactor.setEditable(isEditable);
        this._applyButton.setEnabled(node.isEphemeral());
        this._discardButton.setEnabled(node.isEphemeral());
        this.detectUpdates(true);
        if (node.isEphemeral()) {
            this.updated();
        }
    }

    static {
        $assertionsDisabled = !NodeEditor.class.desiredAssertionStatus();
    }
}

