/*
 * Decompiled with CFR 0.152.
 */
package IceGridGUI.Application;

import IceGridGUI.Application.Root;
import IceGridGUI.Application.TreeNode;
import IceGridGUI.EditorBase;
import IceGridGUI.Utils;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.ButtonBarFactory;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class Editor
extends EditorBase {
    protected JButton _applyButton;
    protected JButton _discardButton;
    protected DocumentListener _updateListener;
    protected TreeNode _target;
    private boolean _detectUpdates = true;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static Map makeParameterValues(Map oldParameterValues, List newParameters) {
        HashMap result = new HashMap();
        Iterator p = newParameters.iterator();
        while (p.hasNext()) {
            Object name = p.next();
            Object value = oldParameterValues.get(name);
            if (value == null) continue;
            result.put(name, value);
        }
        return result;
    }

    public boolean save(boolean refresh) {
        if (this._applyButton.isEnabled()) {
            return this.validate() && this.applyUpdate(refresh);
        }
        return true;
    }

    protected boolean validate() {
        return true;
    }

    protected boolean applyUpdate(boolean refresh) {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return false;
    }

    protected void detectUpdates(boolean val) {
        this._detectUpdates = val;
    }

    protected void discardUpdate() {
        Root root = this._target.getRoot();
        if (this._target.isEphemeral()) {
            this._target.delete();
        } else {
            this._target.getCoordinator().getCurrentTab().showNode(this._target);
        }
        root.cancelEdit();
    }

    protected void appendProperties(DefaultFormBuilder builder) {
    }

    protected void buildPropertiesPanel() {
        super.buildPropertiesPanel();
        JPanel buttonBar = ButtonBarFactory.buildRightAlignedBar(this._applyButton, this._discardButton);
        buttonBar.setBorder(Borders.DIALOG_BORDER);
        this._propertiesPanel.add((Component)buttonBar, "South");
    }

    Editor() {
        AbstractAction apply = new AbstractAction("Apply"){

            public void actionPerformed(ActionEvent e) {
                if (Editor.this.validate() && Editor.this.applyUpdate(true)) {
                    Editor.this._target.getRoot().getTree().grabFocus();
                }
            }
        };
        this._applyButton = new JButton(apply);
        this._applyButton.setEnabled(false);
        AbstractAction discard = new AbstractAction("Discard"){

            public void actionPerformed(ActionEvent e) {
                Editor.this.discardUpdate();
                Editor.this._target.getRoot().getTree().grabFocus();
            }
        };
        this._discardButton = new JButton(discard);
        this._discardButton.setEnabled(false);
        this._updateListener = new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                Editor.this.updated();
            }

            public void insertUpdate(DocumentEvent e) {
                Editor.this.updated();
            }

            public void removeUpdate(DocumentEvent e) {
                Editor.this.updated();
            }
        };
    }

    Object getSubDescriptor() {
        return null;
    }

    Utils.Resolver getDetailResolver() {
        return null;
    }

    public TreeNode getTarget() {
        return this._target;
    }

    void updated() {
        if (this._detectUpdates) {
            this._target.getRoot().disableRegistryUpdates();
            this._applyButton.setEnabled(true);
            this._discardButton.setEnabled(true);
        }
    }

    DocumentListener getUpdateListener() {
        return this._updateListener;
    }

    boolean check(String[] nameValArray) {
        String emptyFields = "";
        int errorCount = 0;
        for (int i = 1; i < nameValArray.length; i += 2) {
            if (nameValArray[i] != null && nameValArray[i].length() != 0) continue;
            ++errorCount;
            if (emptyFields.length() > 0) {
                emptyFields = emptyFields + "\n";
            }
            emptyFields = emptyFields + "'" + nameValArray[i - 1] + "'";
        }
        if (errorCount > 0) {
            String message = errorCount == 1 ? emptyFields + " cannot be empty" : "The following fields cannot be empty:\n" + emptyFields;
            JOptionPane.showMessageDialog(this._target.getCoordinator().getMainFrame(), message, "Validation failed", 0);
        }
        return errorCount == 0;
    }

    static {
        $assertionsDisabled = !Editor.class.desiredAssertionStatus();
    }
}

