/*
 * Decompiled with CFR 0.152.
 */
package IceGridGUI.Application;

import IceGrid.DbEnvDescriptor;
import IceGridGUI.Application.Communicator;
import IceGridGUI.Application.CommunicatorChildEditor;
import IceGridGUI.Application.DbEnv;
import IceGridGUI.Application.PropertiesField;
import IceGridGUI.Utils;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import java.awt.Component;
import javax.swing.JComboBox;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

class DbEnvEditor
extends CommunicatorChildEditor {
    private JTextField _name = new JTextField(20);
    private JTextArea _description = new JTextArea(3, 20);
    private JComboBox _dbHome = new JComboBox<Object>(new Object[]{NO_DB_HOME});
    private PropertiesField _properties;
    private static final Object NO_DB_HOME = new Object(){

        public String toString() {
            return "Created by the IceGrid Node";
        }
    };

    DbEnvEditor() {
        this._name.getDocument().addDocumentListener(this._updateListener);
        this._name.setToolTipText("Identifies this Freeze database environment within an Ice communicator");
        this._description.getDocument().addDocumentListener(this._updateListener);
        this._description.setToolTipText("An optional description for this database environment");
        JTextField dbHomeTextField = (JTextField)this._dbHome.getEditor().getEditorComponent();
        dbHomeTextField.getDocument().addDocumentListener(this._updateListener);
        this._dbHome.setToolTipText("<html><i>node data dir</i>/servers/<i>server id</i>/dbs/<i>db env name</i> if created by the IceGrid Node;<br>otherwise, IceGrid does not create this directory</html>");
        this._properties = new PropertiesField(this);
    }

    void writeDescriptor() {
        DbEnvDescriptor descriptor = (DbEnvDescriptor)this.getDbEnv().getDescriptor();
        descriptor.name = this._name.getText().trim();
        descriptor.description = this._description.getText();
        descriptor.dbHome = this.getDbHomeAsString();
        descriptor.properties = this._properties.getProperties();
    }

    boolean isSimpleUpdate() {
        DbEnvDescriptor descriptor = (DbEnvDescriptor)this.getDbEnv().getDescriptor();
        return descriptor.name.equals(this._name.getText().trim());
    }

    Communicator.ChildList getChildList() {
        return ((Communicator)this._target.getParent()).getDbEnvs();
    }

    protected void appendProperties(DefaultFormBuilder builder) {
        builder.append("Name");
        builder.append((Component)this._name, 3);
        builder.nextLine();
        builder.append("Description");
        builder.nextLine();
        builder.append("");
        builder.nextRow(-2);
        CellConstraints cc = new CellConstraints();
        JScrollPane scrollPane = new JScrollPane(this._description);
        builder.add(scrollPane, cc.xywh(builder.getColumn(), builder.getRow(), 3, 3));
        builder.nextRow(2);
        builder.nextLine();
        builder.append("DB Home");
        builder.append((Component)this._dbHome, 3);
        builder.nextLine();
        builder.append("Properties");
        builder.nextLine();
        builder.append("");
        builder.nextLine();
        builder.append("");
        builder.nextLine();
        builder.append("");
        builder.nextRow(-6);
        scrollPane = new JScrollPane(this._properties);
        builder.add(scrollPane, cc.xywh(builder.getColumn(), builder.getRow(), 3, 7));
        builder.nextRow(6);
        builder.nextLine();
    }

    protected void buildPropertiesPanel() {
        super.buildPropertiesPanel();
        this._propertiesPanel.setName("Database Environment Properties");
    }

    protected boolean validate() {
        return this.check(new String[]{"Name", this._name.getText().trim()});
    }

    void show(DbEnv dbEnv) {
        this.detectUpdates(false);
        this._target = dbEnv;
        DbEnvDescriptor descriptor = (DbEnvDescriptor)dbEnv.getDescriptor();
        Utils.Resolver resolver = null;
        if (dbEnv.getCoordinator().substitute()) {
            resolver = dbEnv.getResolver();
        }
        boolean isEditable = resolver == null;
        this._name.setText(Utils.substitute(descriptor.name, resolver));
        this._name.setEditable(isEditable);
        this._description.setText(Utils.substitute(descriptor.description, resolver));
        this._description.setEditable(isEditable);
        this._description.setOpaque(isEditable);
        this._dbHome.setEnabled(true);
        this._dbHome.setEditable(true);
        this.setDbHome(Utils.substitute(descriptor.dbHome, resolver));
        this._dbHome.setEnabled(isEditable);
        this._dbHome.setEditable(isEditable);
        this._properties.setProperties(descriptor.properties, null, null, resolver, isEditable);
        this._applyButton.setEnabled(dbEnv.isEphemeral());
        this._discardButton.setEnabled(dbEnv.isEphemeral());
        this.detectUpdates(true);
        if (dbEnv.isEphemeral()) {
            this.updated();
        }
    }

    private DbEnv getDbEnv() {
        return (DbEnv)this._target;
    }

    private void setDbHome(String dbHome) {
        if (dbHome.equals("")) {
            this._dbHome.setSelectedItem(NO_DB_HOME);
        } else {
            this._dbHome.setSelectedItem(dbHome);
        }
    }

    private String getDbHomeAsString() {
        Object obj = this._dbHome.getSelectedItem();
        if (obj == NO_DB_HOME) {
            return "";
        }
        return obj.toString().trim();
    }
}

