/*
 * Decompiled with CFR 0.152.
 */
package Ice;

import Ice.FileException;
import Ice.LocalObjectImpl;
import Ice.Logger;
import Ice.Properties;
import Ice.StringSeqHolder;
import Ice.SyscallException;
import Ice.Util;
import IceInternal.PropertyNames;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class PropertiesI
extends LocalObjectImpl
implements Properties {
    private HashMap _properties = new HashMap();
    static final /* synthetic */ boolean $assertionsDisabled;

    public synchronized String getProperty(String key) {
        String result = (String)this._properties.get(key);
        if (result == null) {
            result = System.getProperty(key);
        }
        if (result == null) {
            result = "";
        }
        return result;
    }

    public synchronized String getPropertyWithDefault(String key, String value) {
        String result = (String)this._properties.get(key);
        if (result == null) {
            result = System.getProperty(key);
        }
        if (result == null) {
            result = value;
        }
        return result;
    }

    public int getPropertyAsInt(String key) {
        return this.getPropertyAsIntWithDefault(key, 0);
    }

    public synchronized int getPropertyAsIntWithDefault(String key, int value) {
        String result = (String)this._properties.get(key);
        if (result == null) {
            result = System.getProperty(key);
        }
        if (result == null) {
            return value;
        }
        try {
            return Integer.parseInt(result);
        }
        catch (NumberFormatException ex) {
            return 0;
        }
    }

    public synchronized Map getPropertiesForPrefix(String prefix) {
        HashMap<String, String> result = new HashMap<String, String>();
        Iterator p = this._properties.entrySet().iterator();
        while (p.hasNext()) {
            Map.Entry entry = p.next();
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (prefix.length() != 0 && !key.startsWith(prefix)) continue;
            result.put(key, value);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperty(String key, String value) {
        Logger logger = Util.getProcessLogger();
        if (key == null || key.length() == 0) {
            return;
        }
        int dotPos = key.indexOf(46);
        if (dotPos != -1) {
            String prefix = key.substring(0, dotPos);
            int i = 0;
            while (PropertyNames.validProps[i] != null) {
                String pattern = PropertyNames.validProps[i][0];
                dotPos = pattern.indexOf(46);
                if (!$assertionsDisabled && dotPos == -1) {
                    throw new AssertionError();
                }
                String propPrefix = pattern.substring(1, dotPos - 1);
                if (propPrefix.equals(prefix)) {
                    boolean found = false;
                    int j = 0;
                    while (PropertyNames.validProps[i][j] != null && !found) {
                        pattern = PropertyNames.validProps[i][j];
                        Pattern pComp = Pattern.compile(pattern);
                        Matcher m = pComp.matcher(key);
                        found = m.matches();
                        ++j;
                    }
                    if (!found) {
                        logger.warning("unknown property: " + key);
                    }
                }
                ++i;
            }
        }
        PropertiesI propertiesI = this;
        synchronized (propertiesI) {
            if (value != null && value.length() > 0) {
                this._properties.put(key, value);
            } else {
                this._properties.remove(key);
            }
        }
    }

    public synchronized String[] getCommandLineOptions() {
        String[] result = new String[this._properties.size()];
        Iterator p = this._properties.entrySet().iterator();
        int i = 0;
        while (p.hasNext()) {
            Map.Entry entry = p.next();
            result[i++] = "--" + entry.getKey() + "=" + entry.getValue();
        }
        if (!$assertionsDisabled && i != result.length) {
            throw new AssertionError();
        }
        return result;
    }

    public String[] parseCommandLineOptions(String pfx, String[] options) {
        if (pfx.length() > 0 && pfx.charAt(pfx.length() - 1) != '.') {
            pfx = pfx + '.';
        }
        pfx = "--" + pfx;
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < options.length; ++i) {
            String opt = options[i];
            if (opt.startsWith(pfx)) {
                if (opt.indexOf(61) == -1) {
                    opt = opt + "=1";
                }
                this.parseLine(opt.substring(2));
                continue;
            }
            result.add(opt);
        }
        String[] arr = new String[result.size()];
        result.toArray(arr);
        return arr;
    }

    public String[] parseIceCommandLineOptions(String[] options) {
        String[] args = options;
        int i = 0;
        while (PropertyNames.clPropNames[i] != null) {
            args = this.parseCommandLineOptions(PropertyNames.clPropNames[i], args);
            ++i;
        }
        return args;
    }

    public void load(String file) {
        try {
            FileInputStream fis = new FileInputStream(file);
            InputStreamReader isr = new InputStreamReader((InputStream)fis, "UTF-8");
            BufferedReader br = new BufferedReader(isr);
            this.parse(br);
        }
        catch (IOException ex) {
            FileException fe = new FileException();
            fe.path = file;
            fe.initCause(ex);
            throw fe;
        }
    }

    public synchronized Properties _clone() {
        return new PropertiesI(this);
    }

    PropertiesI(PropertiesI p) {
        this._properties.putAll(p._properties);
    }

    PropertiesI() {
    }

    PropertiesI(StringSeqHolder args, Properties defaults) {
        if (defaults != null) {
            this._properties.putAll(defaults.getPropertiesForPrefix(""));
        }
        boolean loadConfigFiles = false;
        for (int i = 0; i < args.value.length; ++i) {
            if (!args.value[i].startsWith("--Ice.Config")) continue;
            String line = args.value[i];
            if (line.indexOf(61) == -1) {
                line = line + "=1";
            }
            this.parseLine(line.substring(2));
            loadConfigFiles = true;
            String[] arr = new String[args.value.length - 1];
            System.arraycopy(args.value, 0, arr, 0, i);
            if (i < args.value.length - 1) {
                System.arraycopy(args.value, i + 1, arr, i, args.value.length - i - 1);
            }
            args.value = arr;
        }
        if (loadConfigFiles) {
            this.loadConfig();
        }
        args.value = this.parseIceCommandLineOptions(args.value);
    }

    private void parse(BufferedReader in) {
        try {
            String line;
            while ((line = in.readLine()) != null) {
                this.parseLine(line);
            }
        }
        catch (IOException ex) {
            SyscallException se = new SyscallException();
            se.initCause(ex);
            throw se;
        }
    }

    private void parseLine(String line) {
        String s = line;
        int hash = s.indexOf(35);
        if (hash == 0) {
            return;
        }
        if (hash != -1) {
            s = s.substring(0, hash);
        }
        s = s.trim();
        char[] arr = s.toCharArray();
        int end = -1;
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] != ' ' && arr[i] != '\t' && arr[i] != '\r' && arr[i] != '\n' && arr[i] != '=') continue;
            end = i;
            break;
        }
        if (end == -1) {
            return;
        }
        String key = s.substring(0, end);
        if ((end = s.indexOf(61, end)) == -1) {
            return;
        }
        String value = "";
        if (++end < s.length()) {
            value = s.substring(end).trim();
        }
        this.setProperty(key, value);
    }

    private void loadConfig() {
        String value = this.getProperty("Ice.Config");
        if (value.equals("1")) {
            value = "";
        }
        if (value.length() > 0) {
            String[] files = value.split(",");
            for (int i = 0; i < files.length; ++i) {
                this.load(files[i]);
            }
        }
        this.setProperty("Ice.Config", value);
    }

    static {
        $assertionsDisabled = !PropertiesI.class.desiredAssertionStatus();
    }
}

