/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.util.ArrayList;
import javax.xml.transform.SourceLocator;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.ArrayIterator;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.FingerprintedNode;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.ListIterator;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Value;

public final class TextFragmentValue
implements DocumentInfo,
FingerprintedNode,
SourceLocator {
    private CharSequence text;
    private String baseURI;
    private TextFragmentTextNode textNode = null;
    private Configuration config;
    private int documentNumber;

    public TextFragmentValue(CharSequence charSequence, String string) {
        this.text = charSequence;
        this.baseURI = string;
    }

    public void setConfiguration(Configuration configuration) {
        this.config = configuration;
        this.documentNumber = -1;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public NamePool getNamePool() {
        return this.config.getNamePool();
    }

    public int getDocumentNumber() {
        if (this.documentNumber == -1) {
            this.documentNumber = this.config.getDocumentNumberAllocator().allocateDocumentNumber();
        }
        return this.documentNumber;
    }

    public final int getNodeKind() {
        return 9;
    }

    public String getStringValue() {
        return ((Object)this.text).toString();
    }

    public CharSequence getStringValueCS() {
        return this.text;
    }

    public boolean isSameNodeInfo(NodeInfo nodeInfo) {
        return this == nodeInfo;
    }

    public void generateId(FastStringBuffer fastStringBuffer) {
        fastStringBuffer.append("tt");
        fastStringBuffer.append(Integer.toString(this.getDocumentNumber()));
    }

    public void setSystemId(String string) {
        throw new UnsupportedOperationException("A temporary tree does not have a document URI");
    }

    public String getSystemId() {
        return null;
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public int compareOrder(NodeInfo nodeInfo) {
        if (this == nodeInfo) {
            return 0;
        }
        return -1;
    }

    public int getNameCode() {
        return -1;
    }

    public int getFingerprint() {
        return -1;
    }

    public String getPrefix() {
        return "";
    }

    public String getURI() {
        return "";
    }

    public String getDisplayName() {
        return "";
    }

    public String getLocalPart() {
        return "";
    }

    public boolean hasChildNodes() {
        return !"".equals(this.text);
    }

    public int getLineNumber() {
        return -1;
    }

    public int getTypeAnnotation() {
        return -1;
    }

    public void sendNamespaceDeclarations(Receiver receiver, boolean bl) {
    }

    public int[] getDeclaredNamespaces(int[] nArray) {
        return null;
    }

    public SequenceIterator getTypedValue() {
        return SingletonIterator.makeIterator(new UntypedAtomicValue(this.text));
    }

    public Value atomize() {
        return new UntypedAtomicValue(this.text);
    }

    public String getPublicId() {
        return null;
    }

    public int getColumnNumber() {
        return -1;
    }

    public String getAttributeValue(int n) {
        return null;
    }

    public AxisIterator iterateAxis(byte by) {
        switch (by) {
            case 0: 
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                return EmptyIterator.getInstance();
            }
            case 1: 
            case 12: {
                return SingletonIterator.makeIterator(this);
            }
            case 3: 
            case 4: {
                return SingletonIterator.makeIterator(this.getTextNode());
            }
            case 5: {
                Item[] itemArray = new Item[]{this, this.getTextNode()};
                return new ArrayIterator(itemArray);
            }
        }
        throw new IllegalArgumentException("Unknown axis number " + by);
    }

    public AxisIterator iterateAxis(byte by, NodeTest nodeTest) {
        switch (by) {
            case 0: 
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                return EmptyIterator.getInstance();
            }
            case 1: 
            case 12: {
                return Navigator.filteredSingleton(this, nodeTest);
            }
            case 3: 
            case 4: {
                return Navigator.filteredSingleton(this.getTextNode(), nodeTest);
            }
            case 5: {
                TextFragmentTextNode textFragmentTextNode;
                ArrayList<SourceLocator> arrayList = new ArrayList<SourceLocator>(2);
                if (nodeTest.matches(this)) {
                    arrayList.add(this);
                }
                if (nodeTest.matches(textFragmentTextNode = this.getTextNode())) {
                    arrayList.add(textFragmentTextNode);
                }
                return new ListIterator(arrayList);
            }
        }
        throw new IllegalArgumentException("Unknown axis number " + by);
    }

    public NodeInfo getParent() {
        return null;
    }

    public NodeInfo getRoot() {
        return this;
    }

    public DocumentInfo getDocumentRoot() {
        return this;
    }

    public void copy(Receiver receiver, int n, boolean bl, int n2) throws XPathException {
        receiver.characters(this.text, 0, 0);
    }

    public NodeInfo selectID(String string) {
        return null;
    }

    public String[] getUnparsedEntity(String string) {
        return null;
    }

    private TextFragmentTextNode getTextNode() {
        if (this.textNode == null) {
            this.textNode = new TextFragmentTextNode();
        }
        return this.textNode;
    }

    private class TextFragmentTextNode
    implements NodeInfo,
    FingerprintedNode,
    SourceLocator {
        private TextFragmentTextNode() {
        }

        public void setSystemId(String string) {
        }

        public Configuration getConfiguration() {
            return TextFragmentValue.this.config;
        }

        public NamePool getNamePool() {
            return TextFragmentValue.this.config.getNamePool();
        }

        public final int getNodeKind() {
            return 3;
        }

        public String getStringValue() {
            return ((Object)TextFragmentValue.this.text).toString();
        }

        public CharSequence getStringValueCS() {
            return TextFragmentValue.this.text;
        }

        public boolean isSameNodeInfo(NodeInfo nodeInfo) {
            return this == nodeInfo;
        }

        public void generateId(FastStringBuffer fastStringBuffer) {
            fastStringBuffer.append("tt");
            fastStringBuffer.append(Integer.toString(this.getDocumentNumber()));
            fastStringBuffer.append("t1");
        }

        public String getSystemId() {
            return null;
        }

        public String getBaseURI() {
            return TextFragmentValue.this.baseURI;
        }

        public int compareOrder(NodeInfo nodeInfo) {
            if (this == nodeInfo) {
                return 0;
            }
            return 1;
        }

        public int getNameCode() {
            return -1;
        }

        public int getFingerprint() {
            return -1;
        }

        public String getPrefix() {
            return "";
        }

        public String getURI() {
            return "";
        }

        public String getDisplayName() {
            return "";
        }

        public String getLocalPart() {
            return "";
        }

        public boolean hasChildNodes() {
            return false;
        }

        public String getAttributeValue(int n) {
            return null;
        }

        public int getLineNumber() {
            return -1;
        }

        public int getTypeAnnotation() {
            return -1;
        }

        public int getDocumentNumber() {
            return this.getDocumentRoot().getDocumentNumber();
        }

        public void sendNamespaceDeclarations(Receiver receiver, boolean bl) {
        }

        public int[] getDeclaredNamespaces(int[] nArray) {
            return null;
        }

        public SequenceIterator getTypedValue() throws XPathException {
            return SingletonIterator.makeIterator(new UntypedAtomicValue(TextFragmentValue.this.text));
        }

        public Value atomize() throws XPathException {
            return new UntypedAtomicValue(TextFragmentValue.this.text);
        }

        public String getPublicId() {
            return null;
        }

        public int getColumnNumber() {
            return -1;
        }

        public AxisIterator iterateAxis(byte by) {
            switch (by) {
                case 0: 
                case 9: 
                case 13: {
                    return SingletonIterator.makeIterator(TextFragmentValue.this);
                }
                case 1: {
                    Item[] itemArray = new Item[]{this, TextFragmentValue.this};
                    return new ArrayIterator(itemArray);
                }
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 7: 
                case 8: 
                case 10: 
                case 11: {
                    return EmptyIterator.getInstance();
                }
                case 5: 
                case 12: {
                    return SingletonIterator.makeIterator(this);
                }
            }
            throw new IllegalArgumentException("Unknown axis number " + by);
        }

        public AxisIterator iterateAxis(byte by, NodeTest nodeTest) {
            switch (by) {
                case 0: 
                case 9: 
                case 13: {
                    return Navigator.filteredSingleton(TextFragmentValue.this, nodeTest);
                }
                case 1: {
                    boolean bl = nodeTest.matches(TextFragmentValue.this);
                    boolean bl2 = nodeTest.matches(this);
                    if (bl && bl2) {
                        Item[] itemArray = new Item[]{this, TextFragmentValue.this};
                        return new ArrayIterator(itemArray);
                    }
                    if (bl && !bl2) {
                        return SingletonIterator.makeIterator(TextFragmentValue.this);
                    }
                    if (bl2 && !bl) {
                        return SingletonIterator.makeIterator(this);
                    }
                    return EmptyIterator.getInstance();
                }
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 7: 
                case 8: 
                case 10: 
                case 11: {
                    return EmptyIterator.getInstance();
                }
                case 5: 
                case 12: {
                    return Navigator.filteredSingleton(this, nodeTest);
                }
            }
            throw new IllegalArgumentException("Unknown axis number " + by);
        }

        public NodeInfo getParent() {
            return TextFragmentValue.this;
        }

        public NodeInfo getRoot() {
            return TextFragmentValue.this;
        }

        public DocumentInfo getDocumentRoot() {
            return TextFragmentValue.this;
        }

        public void copy(Receiver receiver, int n, boolean bl, int n2) throws XPathException {
            receiver.characters(TextFragmentValue.this.text, 0, 0);
        }
    }
}

