/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.EscapeURI;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.RestrictedStringValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.ValidationErrorValue;
import net.sf.saxon.value.Whitespace;

public final class AnyURIValue
extends StringValue {
    public static final AnyURIValue EMPTY_URI = new AnyURIValue("");
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$net$sf$saxon$value$StringValue;
    static /* synthetic */ Class class$java$net$URI;
    static /* synthetic */ Class class$java$net$URL;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$CharSequence;

    public AnyURIValue(CharSequence charSequence) {
        this.value = charSequence == null ? "" : ((Object)Whitespace.trimWhitespace(charSequence)).toString();
    }

    public static boolean isValidURI(CharSequence charSequence) {
        String string = ((Object)charSequence).toString().trim();
        if (string.length() == 0) {
            return true;
        }
        try {
            new URI(string);
            return true;
        }
        catch (URISyntaxException uRISyntaxException) {
            string = ((Object)EscapeURI.iriToUri(string)).toString();
            try {
                new URI(string);
                return true;
            }
            catch (URISyntaxException uRISyntaxException2) {
                return false;
            }
        }
    }

    public AtomicValue convertPrimitive(BuiltInAtomicType builtInAtomicType, boolean bl, XPathContext xPathContext) {
        int n = builtInAtomicType.getPrimitiveType();
        switch (n) {
            case 88: 
            case 529: 
            case 643: {
                return this;
            }
            case 642: {
                return new UntypedAtomicValue(this.value);
            }
            case 513: {
                return new StringValue(this.value);
            }
            case 553: 
            case 554: 
            case 555: 
            case 556: 
            case 558: 
            case 559: 
            case 560: 
            case 561: 
            case 563: {
                return RestrictedStringValue.makeRestrictedString(this.value, n, bl ? xPathContext.getConfiguration().getNameChecker() : null);
            }
        }
        ValidationException validationException = new ValidationException("Cannot convert anyURI to " + builtInAtomicType.getDisplayName());
        validationException.setErrorCode("XPTY0004");
        return new ValidationErrorValue(validationException);
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        return Type.ANY_URI_TYPE;
    }

    public boolean equals(Object object) {
        AnyURIValue anyURIValue = (AnyURIValue)((AtomicValue)object).getPrimitiveValue();
        return this.getStringValue().equals(anyURIValue.getStringValue());
    }

    public Object convertToJava(Class clazz, XPathContext xPathContext) throws XPathException {
        if (clazz == (class$java$lang$Object == null ? (class$java$lang$Object = AnyURIValue.class$("java.lang.Object")) : class$java$lang$Object)) {
            return this.value;
        }
        if (clazz.isAssignableFrom(class$net$sf$saxon$value$StringValue == null ? (class$net$sf$saxon$value$StringValue = AnyURIValue.class$("net.sf.saxon.value.StringValue")) : class$net$sf$saxon$value$StringValue)) {
            return this;
        }
        if (clazz == (class$java$net$URI == null ? (class$java$net$URI = AnyURIValue.class$("java.net.URI")) : class$java$net$URI)) {
            try {
                return new URI(((Object)this.value).toString());
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new DynamicError("The anyURI value '" + this.value + "' is not an acceptable Java URI");
            }
        }
        if (clazz == (class$java$net$URL == null ? (class$java$net$URL = AnyURIValue.class$("java.net.URL")) : class$java$net$URL)) {
            try {
                return new URL(((Object)this.value).toString());
            }
            catch (MalformedURLException malformedURLException) {
                throw new DynamicError("The anyURI value '" + this.value + "' is not an acceptable Java URL");
            }
        }
        if (clazz == (class$java$lang$String == null ? (class$java$lang$String = AnyURIValue.class$("java.lang.String")) : class$java$lang$String)) {
            return this.value;
        }
        if (clazz == (class$java$lang$CharSequence == null ? (class$java$lang$CharSequence = AnyURIValue.class$("java.lang.CharSequence")) : class$java$lang$CharSequence)) {
            return this.value;
        }
        Object object = super.convertToJava(clazz, xPathContext);
        if (object == null) {
            throw new DynamicError("Conversion of anyURI to " + clazz.getName() + " is not supported");
        }
        return object;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

