#!/usr/bin/env python
from ReleaseForge.version import VERSION
from distutils.core import setup
#from setuptools import setup 
import os
import os.path
import sys
from glob import glob
try:
     import py2exe
except:
     pass

args = sys.argv[1:]

SCRIPTS = ['releaseforge']

if sys.platform == 'win32':
     libpath = r"lib\site-packages\releaseforge"
     MODULES_DIR = os.path.join(libpath, "ReleaseForge")
else:
     libpath = "/usr/share/releaseforge" 
     MODULES_DIR = os.path.join(libpath, "ReleaseForge")

HELP_DIR = os.path.join(libpath, "help")
IMAGES_DIR = os.path.join(libpath, "images")


#TRANSLATIONS_DIR = os.path.join(libpath, "translations")

#########################################################################

setup(name="releaseforge",
      version=VERSION,
      description="ReleaseForge is a utility designed for the administrators and release engineers of SourceForge projects.",
      author="Phil Schwartz",
      author_email="phil_schwartz@users.sourceforge.net",
      url="http://releaseforge.sourceforge.net",
      scripts=SCRIPTS,
      ##package_dir={'': 'modules'},
      packages=['ReleaseForge', 'ReleaseForge/python24'],
      data_files=[(HELP_DIR, glob(os.path.join("help", "*"))),
                  (IMAGES_DIR, glob(os.path.join("images", "*.png"))),
                  (libpath, glob('releaseforge.pro')),
                  (libpath, glob('logger.ini')),
                  (libpath, glob('README.txt')),
                  (libpath, glob('RELEASE_NOTES.txt')),
                  (libpath, glob('CHANGELOG.txt')),
                  (libpath, glob('LICENSE.txt')),
#                  (TRANSLATIONS_DIR, glob(os.path.join("translations", "*"))),
                  (MODULES_DIR, glob("ReleaseForge/*.ui"))
                  ],
      license="GPL",
#      extra_path='releaseforge',
      long_description="""
ReleaseForge is an open source utility designed for the administrators and release engineers
of SourceForge projects. ReleaseForge allows you to easily create new SourceForge project
releases in a quicker and friendlier manner than the usual SourceForge web interface.
      """
      )

