"""
usage:
p = someOOclass(..., callback=MyIterFcn, ...)
or 
p = ...
p.callback = MyIterFcn
or p.callback = (MyIterFcn1, MyIterFcn2, MyIterFcn3, ..., MyIterFcnN)
or p.callback = [MyIterFcn1, MyIterFcn2, MyIterFcn3, ..., MyIterFcnN]

each user-defined function MyIterFunc should return one of the following:

1. a flag value - 0, 1, True, False
flag = True or 1 means user want to stop calculations
 (r.istop=80, r.msg = 'user-defined' ) 

2. someRealValue like 15 or 80.15 or 1.5e4 (r.istop=someRealValue, r.msg = 'user-defined')

3. Python list (or tuple) - [istop, msg] (r.istop=istop, r.msg=msg)

works for ralg and lincher, but may doesn't work for some other solvers 
(like scipy_cobyla, that has neither native callback nor call gradient)
"""

def MyIterFcn(p):
    # observing non-feasible ralg iter points
    
    if p.rk > p.contol: # p.rk is current iter max residual
        print '--= non-feasible ralg iter =--'
        print 'itn:',  p.iter 
        #however, I inted to change p.iter to p.iter in OpenOpt code soon
        
        print 'curr f:',  p.fk
        # print 'curr x[:8]:',  p.xk[:8]
        print 'max constraint value',  p.rk
    
    """
    BTW you can store data in any unique field of p
    for example 
    if some_cond:  p.JohnSmith = 15
    else: p.JohnSmith = 0
    
    However, special field "user" is intended for the purpose:
    p.user.mydata1 = (something)
    # or, for another example:
    if p.iter == 0: p.user.mylist = []
    p.user.mylist.append(something)
    """
    
    if p.fk < 1.5 and p.rk < p.contol: 
        #NB! you could use p.fEnough = 15, p.contol=1e-5 in prob assignment instead
        return (15, 'value obtained is enough' )
        # or 
        # return 15 (hence r.istop=15, r.msg='user-defined')
        # or return True (hence r.istop=80, r.msg='user-defined')
        # or return 1 (hence r.istop = 80, r.msg='user-defined')
    else: 
        return False
        # or 
        # return 0
    
from scikits.openopt import NSP
from numpy import cos,  asfarray,  arange,  sign
N = 75
f = lambda x: sum(1.2 ** arange(len(x)) * abs(x))
df = lambda x: 1.2 ** arange(len(x)) * sign(x)
x0 = cos(1+asfarray(range(N)))

p = NSP(f,  x0,  df=df,  callback=MyIterFcn,  contol = 1e-5,  maxIter = 1e4,  iprint = 100)
p.c = lambda x: abs(x[4]-0.8) + abs(x[5]-1.5) - 0.015
#optional: 
#p.plot = 1
r = p.solve('ralg')
print r.xf[:8]

"""
starting solver ralg (license: BSD)  with problem  unnamed
itn 0 : Fk= 2824966.83813 MaxResidual= 1.04116752789
--= non-feasible ralg iter =--
itn: 0
curr f: [ 2824966.83813157]
max constraint value 1.04116752789
--= non-feasible ralg iter =--
itn: 1
curr f: [ 2824970.06389614]
max constraint value 0.343046034487
--= non-feasible ralg iter =--
itn: 2
curr f: [ 2824968.85423442]
max constraint value 0.157284051403
--= non-feasible ralg iter =--
itn: 3
curr f: [ 2824969.45906528]
max constraint value 0.0778809915417
--= non-feasible ralg iter =--
itn: 4
curr f: [ 2824969.15664985]
max constraint value 0.0247015299307
--= non-feasible ralg iter =--
itn: 5
curr f: [ 2824969.30785756]
max constraint value 0.0115897308055
--= non-feasible ralg iter =--
itn: 6
curr f: [ 2824969.23225371]
max constraint value 0.00849189931885
--= non-feasible ralg iter =--
itn: 7
curr f: [ 2824969.33884846]
max constraint value 0.492613712337
--= non-feasible ralg iter =--
itn: 8
curr f: [ 2824969.23225371]
max constraint value 0.00849189931885
--= non-feasible ralg iter =--
itn: 9
curr f: [ 2824969.2589024]
max constraint value 0.0942845035952
--= non-feasible ralg iter =--
itn: 10
curr f: [ 2824969.23225371]
max constraint value 0.00849189931885
itn 100 : Fk= 17069.511925 MaxResidual=0.00e+00 ls= 0
itn 200 : Fk= 3414.10073216 MaxResidual=0.00e+00 ls= 0
itn 300 : Fk= 677.859710072 MaxResidual=0.00e+00 ls= 0
itn 400 : Fk= 161.346642229 MaxResidual=0.00e+00 ls= 0
itn 500 : Fk= 60.7027237393 MaxResidual=0.00e+00 ls= 0
--= non-feasible ralg iter =--
itn: 578
curr f: [ 27.91842239]
max constraint value 6.24426861277e-05
itn 600 : Fk= 21.6764999085 MaxResidual=0.00e+00 ls= 0
itn 700 : Fk= 12.5169643207 MaxResidual=0.00e+00 ls= 0
itn 800 : Fk= 7.57478371116 MaxResidual=0.00e+00 ls= 0
itn 900 : Fk= 6.62378055943 MaxResidual=0.00e+00 ls= 0
--= non-feasible ralg iter =--
itn: 927
curr f: [ 6.16120658]
max constraint value 0.000134846161715
itn 1000 : Fk= 5.71836744086 MaxResidual=0.00e+00 ls= 0
--= non-feasible ralg iter =--
itn: 1073
curr f: [ 5.5631041]
max constraint value 9.85148917757e-05
--= non-feasible ralg iter =--
itn: 1093
curr f: [ 5.52060738]
max constraint value 1.27847590301e-05
itn 1100 : Fk= 5.52098442967 MaxResidual=0.00e+00 ls= 0
itn 1200 : Fk= 5.41042442915 MaxResidual=0.00e+00 ls= 0
--= non-feasible ralg iter =--
itn: 1249
curr f: [ 5.39170524]
max constraint value 1.83549094677e-05
--= non-feasible ralg iter =--
itn: 1273
curr f: [ 5.38684431]
max constraint value 9.76485916604e-05
itn 1300 : Fk= 5.37711869183 MaxResidual=0.00e+00 ls= 0
--= non-feasible ralg iter =--
itn: 1398
curr f: [ 5.36265833]
max constraint value 1.19372030116e-05
itn 1400 : Fk= 5.36252872692 MaxResidual=0.00e+00 ls= 0
--= non-feasible ralg iter =--
itn: 1429
curr f: [ 5.36105646]
max constraint value 1.92304779728e-05
itn 1500 : Fk= 5.35823803209 MaxResidual=0.00e+00 ls= 0
--= non-feasible ralg iter =--
itn: 1548
curr f: [ 5.35651366]
max constraint value 1.04851597451e-05
--= non-feasible ralg iter =--
itn: 1583
curr f: [ 5.3557011]
max constraint value 1.39563678882e-05
itn 1600 : Fk= 5.35573186663 MaxResidual=0.00e+00 ls= 0
itn 1601 : Fk= 5.35573213507 MaxResidual=0.00e+00 ls= 0
solver ralg has finished solving the problem unnamed
istop:  4 (|| F[k] - F[k-1] || < ftol)
Solver:   Time Elapsed = 3.83 	CPU Time Elapsed = 3.46
objFunValue: 5.35573213507 (feasible, max constraint =  0)
[ -4.01239877e-05  -2.75097558e-05  -2.59255724e-08  -1.87457124e-05
   7.99947105e-01   1.48505533e+00  -5.29523297e-06  -2.74567562e-06]
"""
