//
//  BBBluetoothChannelDelegate.m
//  BTUtil
//
//  Created by Bea on 23/02/07.
//  Copyright 2007 __MyCompanyName__. All rights reserved.
//

#import "BBBluetoothChannelDelegate.h"

#import <IOBluetooth/objc/IOBluetoothRFCOMMChannel.h>
#import <IOBluetooth/objc/IOBluetoothL2CAPChannel.h>

static SEL channelDataSelector;
static SEL channelWriteSelector;
static SEL channelClosedSelector;


@implementation BBBluetoothChannelDelegate

+ (void)initialize
{
    channelDataSelector = @selector(channelData:data:);
    channelWriteSelector = @selector(channelWriteComplete:refcon:status:);
    channelClosedSelector = @selector(channelClosed:);
}

- (id)initWithDelegate:(id)delegate
{
    self = [super init];
    m_delegate = delegate;
    return self;
}

- (void)rfcommChannelData:(IOBluetoothRFCOMMChannel *)rfcommChannel 
                     data:(void *)dataPointer 
                   length:(size_t)dataLength
{
    if (m_delegate && [m_delegate respondsToSelector:channelDataSelector]) {
        [m_delegate channelData:rfcommChannel 
                           data:[NSData dataWithBytes:dataPointer length:dataLength]];
    }
}

- (void)rfcommChannelWriteComplete:(IOBluetoothRFCOMMChannel*)rfcommChannel 
                            refcon:(void*)refcon 
                            status:(IOReturn)error
{
    if (m_delegate && [m_delegate respondsToSelector:channelWriteSelector]) {
        [m_delegate channelWriteComplete:rfcommChannel 
                                  refcon:refcon
                                  status:error];
    }    
}

- (void)rfcommChannelClosed:(IOBluetoothRFCOMMChannel *)rfcommChannel
{
    if (m_delegate && [m_delegate respondsToSelector:channelClosedSelector]) {
        [m_delegate channelClosed:rfcommChannel];
    }        
}

- (void)l2capChannelData:(IOBluetoothL2CAPChannel *)l2capChannel 
                    data:(void *)dataPointer 
                  length:(size_t)dataLength
{
    if (m_delegate && [m_delegate respondsToSelector:channelDataSelector]) {
        [m_delegate channelData:l2capChannel 
                           data:[NSData dataWithBytes:dataPointer length:dataLength]];
    }    
}

- (void)l2capChannelClosed:(IOBluetoothL2CAPChannel *)l2capChannel
{
    if (m_delegate && [m_delegate respondsToSelector:channelClosedSelector]) {
        [m_delegate channelClosed:l2capChannel];
    }            
}

@end
