/* KInterbasDB Python Package - Header File for Platform-Specific Events Support
**
** Version 3.1
**
** The following contributors hold Copyright (C) over their respective
** portions of code (see license.txt for details):
**
** [Original Author (maintained through version 2.0-0.3.1):]
**   1998-2001 [alex]  Alexander Kuznetsov   <alexan@users.sourceforge.net>
** [Maintainers (after version 2.0-0.3.1):]
**   2001-2002 [maz]   Marek Isalski         <kinterbasdb@maz.nu>
**   2002-2004 [dsr]   David Rushby          <woodsplitter@rocketmail.com>
** [Contributors:]
**   2001      [eac]   Evgeny A. Cherkashin  <eugeneai@icc.ru>
**   2001-2002 [janez] Janez Jere            <janez.jere@void.si>
*/

#ifndef _KIEVENTS_PLATFORM_DEFS_H
#define _KIEVENTS_PLATFORM_DEFS_H

#ifdef ENABLE_DB_EVENT_SUPPORT

#include "pythread.h"

#ifdef MS_WIN32

  #include <windows.h>

  typedef HANDLE *PlatformEventType;

#else /* If not Windows, assume UNIX. */

  /* #include <unistd.h> */
  #include <pthread.h>

  /* Must use a condition,mutex pair. */
  typedef struct {
    pthread_cond_t cond;
    pthread_mutex_t mutex;
  } platform_event_struct;

  typedef platform_event_struct *PlatformEventType;

#endif


#endif /* ENABLE_DB_EVENT_SUPPORT */

#endif /* if not def _KIEVENTS_PLATFORM_DEFS_H */
