/*

Copyright (C) 2007 Robert S. Edmonds 

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

*/

#ifndef CFGOPT_H
#define CFGOPT_H

#include <stdbool.h>

/* declarations */

enum CFGOPT_TYPE {
	CONFIG_STR,
	CONFIG_DEC,
	CONFIG_OCT,
	CONFIG_BOOL,
	CONFIG_END
};

typedef struct cfgopt {
	char cmd;
	char *key;
	enum CFGOPT_TYPE type;
	union {
		char *str;
		long *num;
		bool *boolean;
	} val;
	char *default_value;
	char *help;
} cfgopt_t;

#define cfgopt_dir { 'C', "configfile", CONFIG_STR, {}, NULL, "config file" }
#define cfgopt_end { '\0', "", CONFIG_END, {}, "", "" }

/* functions */

bool cfgopt_load(cfgopt_t *, char *fname);
size_t cfgopt_len(cfgopt_t *);
void cfgopt_free(cfgopt_t *);
void cfgopt_parse_args(cfgopt_t *cfg, int argc, char **argv);
void cfgopt_print(cfgopt_t *);
void cfgopt_usage(cfgopt_t *);

bool cfgopt_is_set(cfgopt_t *cfg, char *key);
cfgopt_t *cfgopt_get(cfgopt_t *, char *key);
char *cfgopt_get_str(cfgopt_t *cfg, char *key);
char *cfgopt_get_str_dup(cfgopt_t *cfg, char *key);
long cfgopt_get_num(cfgopt_t *cfg, char *key);

#endif
