#TRUSTED 07f1a60746ecd38a82386b3d269b23d476e2d8a8df999c27b4ee9850b66de7e01ba80093c2dbf00f4c796ce7442fc7abc4bf183523438d494a08a6b44c9c9d2bec5b8a807d51fc46e44ac923cf6fbca3ea93f39737d1981fc22f4321d5957e2d0af26ee734f322113297c76b7f5f325d2c242e72f06f35e68cdbf645cc0f7df475f1ddbd4cb9d26208ee7c1a07e218f8b84a41e4d6da2e22c6ce6cfe91970c050167e19e2f4765203281166f1b9625017e0ce46255dca3848bb9aebc056099f0408f02717fd854bd82d21f3d6415d5c92d10a010d8d7e8e13575f284eaccb079f643f9889115e2657d1953ffdc6cbf738793125480d8ad25d518563e266912cf54911f9339df21d64ea3d8dd330a0177bd96842cf6faf4ed005f37f3a73e034e35c5265ce0e5d0915326990a17de7c21039b8e688b3f56ba1a75929ae36a424f4e7cbe3b66d9c8b7788064b3c7a1727cbfdf1d657127a4e3da4a1c59883aeae09587277f4336d48d78897de8963a01c7173d7814b9eb11c4b151c0d08937ce14da6d363898b9a32987298ee5d5757c8c56a7217f26f86a0e79163c6d44b4e4d7fe2440b5a1182a42eb87bcb3cfb054b77970766efcdf1f47ba504c6f650e1bf81f1b45603b3dba4f129aeddd2844404afb7c38930ab53de506764f864a2e9f1e263d6205db6177719686f6ec41a0f77556b019a890ef00108a24a2852221b79f
#
# This script was written by Michel Arboi <arboi@alussinan.org>
#
# GPL
#

# No use to run this one if the other plugins cannot run!
if ( ! defined_func("script_get_preference_file_location")) exit(0);
if ( ! find_in_path("hydra") ) exit(0);


if(description)
{
 script_id(15887);
 script_version ("1.3");
 name["english"] = "Hydra: Socks5";
 script_name(english:name["english"]);
 
 desc["english"] = "
This plugin runs Hydra to find Socks5 accounts & passwords by brute force.

See the section 'plugins options' to configure it
";

 script_description(english:desc["english"]);
 
 summary["english"] = "Brute force Socks5 authentication with Hydra";
 script_summary(english:summary["english"]);
 
 script_category(ACT_ATTACK);
 script_timeout(0);
 script_copyright(english:"This script is Copyright (C) 2004 Michel Arboi");
 script_family(english:"Brute force attacks");
 script_require_keys("Secret/hydra/logins_file", "Secret/hydra/passwords_file");
 script_require_ports("Services/socks5", 1080);
 script_dependencies("hydra_options.nasl", "find_service1.nasl", "socks.nasl");
 exit(0);
}

#
force = get_kb_item("/tmp/hydra/force_run");
if (! force)
{
throrough = get_kb_item("global_settings/thorough_tests");
if ("yes" >!< throrough) exit(0);
}

logins = get_kb_item("Secret/hydra/logins_file");
if (logins == NULL) exit(0);

port = get_kb_item("Services/socks5");
if (! port) exit(0);
if (! get_port_state(port)) exit(0);

auth = get_kb_item("socks5/auth/"+port);
if (!auth) exit(0);	# Not authentication is required

# TBD: check that the SOCKS server is up & running

timeout = get_kb_item("/tmp/hydra/timeout"); timeout = int(timeout);
tasks = get_kb_item("/tmp/hydra/tasks"); task = int(tasks);

empty = get_kb_item("/tmp/hydra/empty_password");
login_pass = get_kb_item("/tmp/hydra/login_password");
exit_asap = get_kb_item("/tmp/hydra/exit_ASAP");
tr = get_kb_item("Transports/TCP/"+port);

i = 0;
argv[i++] = "hydra";
argv[i++] = "-s"; argv[i++] = port;
argv[i++] = "-L"; argv[i++] = logins;
s = "";
if (empty) s = "n";
if (login_pass) s+= "s";
if (s)
{
  argv[i++] = "-e"; argv[i++] = s;
}
passwd = get_kb_item("Secret/hydra/passwords_file");
if (passwd != NULL)
{
 argv[i++] = "-P"; argv[i++] = passwd;
}
else if (!s)
 exit(0);

if (exit_asap) argv[i++] = "-f";
if (tr >= ENCAPS_SSLv2) argv[i++] = "-S";

if (timeout > 0)
{
  argv[i++] = "-w";
  argv[i++] = timeout;
}
if (tasks > 0)
{
  argv[i++] = "-t";
  argv[i++] = tasks;
}

argv[i++] = get_host_ip();
argv[i++] = "socks5";

report = "";
results = pread(cmd: "hydra", argv: argv, nice: 5);
foreach line (split(results))
{
  v = eregmatch(string: line, pattern: 'host:.*login: *(.*) password: *(.*)$');
  if (! isnull(v))
  {
    l = chomp(v[1]);
    p = chomp(v[2]);
    report = strcat(report, 'login: ', l, '\tpassword: ', p, '\n');
    set_kb_item(name: 'Hydra/socks5/'+port, value: l + '\t' + p);
  }
}

if (report)
  security_hole(port: port, 
    data: 'Hydra was able to break the following accounts on the Socks5 server:\n' + report);
