#TRUSTED 0e441622819b2108dc9bffb1f2ac4fdd41dab287ebe62cb316d6dec2f273f6b366d230965b57baf417d4c16909932858e8b312563e6f6af818de7b0ce8e6bc7d546208e1003646c4b5c45d28d1c250e8e6eb30a1736551a944399f5c439c60dbe4a885f3a6917c296ed3979406ebb0d3317702ff1cdb3d98ff652b8aed69fb7b4826d77207807521b08bef2ae524f7692dcc6e6bf29c55911938f562f33e87f314973c917264804b4632dfe7608d02eee422456a3b85c37c24316b4326466d19a8bfb540b71b2b706c0a02e2270b6d3e4e7d032a9fe5768a9c13baa45545ebf317601a9af4db6388d024aabc50b25e9b284947108c9ab8e8162d76186e94515762af76d1d06ce15debd5885f60cf63b421b67d9840d1dda69e1c372d33e323f18a7af119a468a0da00b25067c7ad2142b58b08574d387f83ea6f690a3b7c84bbea106e4e8ff55ab0ba35877e644286c7302a5f6d7b9f7cd9f007b11f0fd71e8dac4153be1e544c61dccdb0d855a486a9a9f17a9cdecc3e818e14e9bb0834da922b455808fda351201405ced726f36459ac65d76048929627092d23a9ff93c9f668a771be060d16e99ab6382c71f01a0ed441f00a463aac738556e09d619c3d8e8877e2aa08059df97321c8f3c3fbd8cabb6e09a611b273501fc56b5cf5a6ed06be2a42009d4a479cbaa31ccbe82c6e0e2e303f2cc813d867eca0e4fe190dcd42
#
# This script was written by Michel Arboi <arboi@alussinan.org>
#
# GPL
#

# No use to run this one if the other plugins cannot run!
if (! defined_func("script_get_preference_file_location")) exit(0);
if (! find_in_path("hydra") ) exit(0);


if(description)
{
 script_id(15868);
 script_version ("1.3");
 name["english"] = "Hydra (NASL wrappers options)";
 script_name(english:name["english"]);
 
 desc["english"] = "
This plugin sets options for the hydra(1) tests.
Hydra finds passwords by brute force.

See the section 'plugins options' to configure it
";

 script_description(english:desc["english"]);
 
 summary["english"] = "Brute force authentication protocols";
 script_summary(english:summary["english"]);
 
 script_category(ACT_SETTINGS);
 
 script_copyright(english:"This script is Copyright (C) 2004 Michel Arboi");
 script_family(english:"Brute force attacks");

 script_add_preference(name: "Always enable Hydra (slow)", type:"checkbox", value: "no");
 script_add_preference(name: "Logins file : ", value: "", type: "file");
 script_add_preference(name: "Passwords file : ", value: "", type: "file");
 script_add_preference(name: "Number of parallel tasks :", value: "16", type: "entry");
 script_add_preference(name: "Timeout (in seconds) :", value: "30", type: "entry");
 script_add_preference(name: "Try empty passwords", type:"checkbox", value: "yes");
 script_add_preference(name: "Try login as password", type:"checkbox", value: "yes");
 script_add_preference(name: "Exit as soon as an account is found", type:"checkbox", value: "no");
 script_add_preference(name: "Add accounts found by other plugins to login file", type:"checkbox", value: "yes");

 exit(0);
}

#

function mk_login_file(logins)
{
  local_var	tmp1,tmp2, dir, list, i, u;
  if ( NASL_LEVEL < 2201 ) return logins; # fwrite broken
  dir = get_tmp_dir();
  if (! dir) return logins;	# Abnormal condition
  for (i = 1; TRUE; i ++)
  {
    u = get_kb_item("SMB/Users/"+i);
    if (! u) break;
    list = strcat(list, u, '\n');
  }
# Add here results from other plugins
  if (! list) return logins;
  tmp1 = strcat(dir, 'hydra-'+ get_host_ip() + '-' + rand());
  tmp2 = strcat(dir, 'hydra-'+ get_host_ip() + '-' + rand());
  if (fwrite(data: list, file: tmp1) <= 0)	# File creation failed
    return logins;
  if (! logins) return tmp1;
  pread(cmd: "sort", argv: make_list("sort", "-u", tmp1, logins, "-o", tmp2));
  unlink(tmp1);
  return tmp2;
}


if ( ! script_get_preference("Passwords file : ") ) exit(0);
p = script_get_preference_file_location("Passwords file : ");
if (!p ) exit(0);
set_kb_item(name: "Secret/hydra/passwords_file", value: p);

# No login file is necessary for SNMP, VNC and Cisco; and a login file 
# may be made from other plugins results. So we do not exit if this
# option is void.
a = script_get_preference("Add accounts found by other plugins to login file");
if ( ! script_get_preference("Logins file : ") ) exit(0);
p = script_get_preference_file_location("Logins file : ");
if ("no" >!< a) p = mk_login_file(logins: p);
set_kb_item(name: "Secret/hydra/logins_file", value: p);

p = script_get_preference("Timeout (in seconds) :");
t = int(p);
if (t <= 0) t = 30;
set_kb_item(name: "/tmp/hydra/timeout", value: t);

p = script_get_preference("Number of parallel tasks :");
t = int(p);
if (t <= 0) t = 16;
set_kb_item(name: "/tmp/hydra/tasks", value: t);

p = script_get_preference("Try empty passwords");
if ( "yes" >< p ) 
  set_kb_item(name: "/tmp/hydra/empty_password", value: TRUE);

p = script_get_preference("Try login as password");
if ( "yes" >< p ) 
 set_kb_item(name: "/tmp/hydra/login_password", value: TRUE);

p = script_get_preference("Exit as soon as an account is found");
if ( "yes" >< p ) 
 set_kb_item(name: "/tmp/hydra/exit_ASAP", value: TRUE);

p = script_get_preference("Always enable Hydra (slow)");
if ("yes" >< p)
 set_kb_item("/tmp/hydra/force_run", value: TRUE);
