#TRUSTED 47f9875c55d23db997ca1862c75f97d88200b1929640434c8f6f063dff7fd902e7cf6b952d150966b21c644465bbd583e2bd78af8b1903f3cae2aa18f879cd2e946252c7c7f4522e852e6edb7ef9591498c81fbdb83a15a6c1abfe9e31bfcc9c91541456a76270c9662c299d1e0c1bbcf8831503a5d8087347fcf4ea49986ff9d4e4a4bdc77ce061e23392576a008b34f52460152660a027f1c6894bd08f67c4cfeaead8b82d479519a9c57576cb6767df7dc457c02a88f68b60253168e64bfb8dffd631eb95caa35087d67eb85e83e1a85aed82e7b124fe125301a7f1c2db495210d257291e1f1fe96e70b9bb40ecea5668fc4ef55ffdfafa9cf52f0d642019841cc720a6e6510edae9b4a7ccc8a177712c5b7b675c239cdaccc5cb468731e2839b38f2a867c08726bc023df3d2ed67ad666d26b7f469867e30c41086b9b61cfa36e2ec9e7e0cd3b57b3a9e8cc4d44bf1046c01c82ba2e8b4694c4a19f3a5db36d787fce7e0cfa5dc85ee4432d66ddff98687026758a21a8ef852ec4c966906c3cd40b9e9636e768940f65203704f111f370cb10782fd8e53586bf4659bb5bcf857ffc6b293994e25f77daf68805985c6efc4b47a6e500d973dbeaa7529cb3337d62e539dc7399b0749d385c2d5210dab04a7486c487801420362a6eafad95d7ccff806aac2e77c31c3b65d8560e22ca24e7ccd1211c9d5828cc8f733c8199f
#
# This script was written by Michel Arboi <arboi@alussinan.org>
#
# GPL
#

if (! defined_func("script_get_preference_file_location")) exit(0);
if (! find_in_path("hydra")) exit(0);


if(description)
{
 script_id(15872);
 script_version ("1.3");
 name["english"] = "Hydra: FTP";
 script_name(english:name["english"]);
 
 desc["english"] = "
This plugin runs Hydra to find FTP accounts & passwords by brute force.

See the section 'plugins options' to configure it
";

 script_description(english:desc["english"]);
 
 summary["english"] = "Brute force FTP authentication with Hydra";
 script_summary(english:summary["english"]);
 
 script_category(ACT_ATTACK);
 script_timeout(0);
 script_copyright(english:"This script is Copyright (C) 2004 Michel Arboi");
 script_family(english:"Brute force attacks");
 script_require_keys("Secret/hydra/logins_file", "Secret/hydra/passwords_file");
 script_require_ports("Services/ftp", 21);
 script_dependencies("hydra_options.nasl", "ftpserver_detect_type_nd_version.nasl");
 exit(0);
}

#
force = get_kb_item("/tmp/hydra/force_run");
if (! force)
{
throrough = get_kb_item("global_settings/thorough_tests");
if ("yes" >!< throrough) exit(0);
}

logins = get_kb_item("Secret/hydra/logins_file");
if (logins == NULL) exit(0);

port = get_kb_item("Services/ftp");
if (! port) exit(0); # port = 21;
if (! get_port_state(port)) exit(0);

# Check that the FTP server is still alive & answers quickly enough
soc = open_sock_tcp(port);
if (!soc) exit(0);
r = recv_line(socket: soc, length: 1024);
close(soc);
if (r !~ '^2[0-9][0-9][ -]') exit(0);

timeout = get_kb_item("/tmp/hydra/timeout"); timeout = int(timeout);
tasks = get_kb_item("/tmp/hydra/tasks"); task = int(tasks);

empty = get_kb_item("/tmp/hydra/empty_password");
login_pass = get_kb_item("/tmp/hydra/login_password");
exit_asap = get_kb_item("/tmp/hydra/exit_ASAP");
tr = get_kb_item("Transports/TCP/"+port);

i = 0;
argv[i++] = "hydra";
argv[i++] = "-s"; argv[i++] = port;
argv[i++] = "-L"; argv[i++] = logins;
s = "";
if (empty) s = "n";
if (login_pass) s+= "s";
if (s)
{
  argv[i++] = "-e"; argv[i++] = s;
}
passwd = get_kb_item("Secret/hydra/passwords_file");
if (passwd)
{
 argv[i++] = "-P"; argv[i++] = passwd;
} else if (s)
 exit(0);

if (exit_asap) argv[i++] = "-f";
if (tr >= ENCAPS_SSLv2) argv[i++] = "-S";

if (timeout > 0)
{
  argv[i++] = "-w";
  argv[i++] = timeout;
}
if (tasks > 0)
{
  argv[i++] = "-t";
  argv[i++] = tasks;
}

argv[i++] = get_host_ip();
argv[i++] = "ftp";

report = "";
results = pread(cmd: "hydra", argv: argv, nice: 5);
foreach line (split(results))
{
  v = eregmatch(string: line, pattern: 'host:.*login: *(.*) password: *(.*)$');
  if (! isnull(v))
  {
    l = chomp(v[1]);
    p = chomp(v[2]);
    report = strcat(report, 'username: ', l, '\tpassword:', p, '\n');
    set_kb_item(name: 'Hydra/ftp/'+port, value: l + '\t' + p);
  }
}

if (report)
  security_hole(port: port, 
    data: 'Hydra was able to break the following FTP accounts:\n' + report);
