/*
    VLDocking Framework 2.1
    Copyright VLSOLUTIONS, 2004-2006

    email : info@vlsolutions.com
------------------------------------------------------------------------
This software is distributed under the CeCILL license, a GNU GPL-compatible
license adapted to french law.
French and English license headers are provided at the begining of
the source files of this software application.
------------------------------------------------------------------------
LICENCE CeCILL (FRENCH VERSION).
------------------------------------------------------------------------
Ce logiciel est un programme informatique servant  amliorer les interfaces
homme-machine d'applications Java bases sur Swing, en leur apportant un
ensemble de fonctions relatives au dockage des composants.

Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA
sur le site "http://www.cecill.info".

En contrepartie de l'accessibilit au code source et des droits de copie,
de modification et de redistribution accords par cette licence, il n'est
offert aux utilisateurs qu'une garantie limite.  Pour les mmes raisons,
seule une responsabilit restreinte pse sur l'auteur du programme,  le
titulaire des droits patrimoniaux et les concdants successifs.

A cet gard  l'attention de l'utilisateur est attire sur les risques
associs au chargement,   l'utilisation,   la modification et/ou au
dveloppement et  la reproduction du logiciel par l'utilisateur tant
donn sa spcificit de logiciel libre, qui peut le rendre complexe 
manipuler et qui le rserve donc  des dveloppeurs et des professionnels
avertis possdant  des  connaissances  informatiques approfondies.  Les
utilisateurs sont donc invits  charger  et  tester  l'adquation  du
logiciel  leurs besoins dans des conditions permettant d'assurer la
scurit de leurs systmes et ou de leurs donnes et, plus gnralement,
 l'utiliser et l'exploiter dans les mmes conditions de scurit.

Le fait que vous puissiez accder  cet en-tte signifie que vous avez
pris connaissance de la licence CeCILL, et que vous en avez accept les
termes.

------------------------------------------------------------------------
CeCILL License (ENGLISH VERSION)
------------------------------------------------------------------------

This software is a computer program whose purpose is to enhance Human-Computer
Interfaces written in Java with the Swing framework, providing them a set of
functions related to component docking.

This software is governed by the CeCILL  license under French law and
abiding by the rules of distribution of free software.  You can  use,
modify and/ or redistribute the software under the terms of the CeCILL
license as circulated by CEA, CNRS and INRIA at the following URL
"http://www.cecill.info".

As a counterpart to the access to the source code and  rights to copy,
modify and redistribute granted by the license, users are provided only
with a limited warranty  and the software's author,  the holder of the
economic rights,  and the successive licensors  have only  limited
liability.

In this respect, the user's attention is drawn to the risks associated
with loading,  using,  modifying and/or developing or reproducing the
software by the user in light of its specific status of free software,
that may mean  that it is complicated to manipulate,  and  that  also
therefore means  that it is reserved for developers  and  experienced
professionals having in-depth computer knowledge. Users are therefore
encouraged to load and test the software's suitability as regards their
requirements in conditions enabling the security of their systems and/or
data to be ensured and,  more generally, to use and operate it in the
same conditions as regards security.

The fact that you are presently reading this means that you have had
knowledge of the CeCILL license and that you accept its terms.

*/


package com.vlsolutions.swing.docking;

import com.vlsolutions.swing.docking.ui.DockingUISettings;
import java.awt.Color;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.JPopupMenu;
import javax.swing.SwingConstants;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.border.Border;

/** This is the centralized settings repository for managing docking look and feel.
 * <p>
 * It acts as a facade for installing common settings.
 *<p>
 * This class contains only high-level settings, like the heavyweight components support
 * or the global desktop style (shadowed or flat). To access low-level properties, use
 * the DockingUISettings class instead.
 *
 * @author Lilian Chamontin, VLSolutions
 * @since 1.1
 * @see com.vlsolutions.swing.docking.ui.DockingUISettings
 */
public class DockingPreferences {

    private static boolean isLightWeightUsageEnabled = true;
    private static boolean isSingleHeavyWeightComponent = false;
    
            
    /** private stuff : use static methods only  */
    private DockingPreferences() {
    }
    
    public static final AutoHidePolicy getAutoHidePolicy(){
        return AutoHidePolicy.getPolicy();
    }
    
    /** A simple utility method to configure the docking framework to work properly with 
     * heavyweight component.
     *<p>
     * Don't forget to invoke also the following general swing methods : 
     * <pre>
     *      ToolTipManager.sharedInstance().setLightWeightPopupEnabled(false);
     *      JPopupMenu.setDefaultLightWeightPopupEnabled(false);        
     *</pre>
     *<p>
     * If you are sure you will always use heavyweight component, you can replace this 
     * method invocation by initHeavyWeightUsage(), which will do all the work for you
     * (even the general swing methods invocation).
     * 
     */
    public static void setLightweigthComponentEnabled(boolean lightweight){
        isLightWeightUsageEnabled = lightweight;
    }
    
    public static boolean isLightWeightUsageEnabled(){
        return isLightWeightUsageEnabled;
    }

    /** Notifies the framework that there is only one dockable that is heavyweight.
     * <p> This allows optimizations and workarounds (for properly using the JDIC WebBrowser 
     *  for example).
     */
    public static void setSingleHeavyWeightComponent(boolean single){
        isSingleHeavyWeightComponent = single;
    }
    
    public static boolean isSingleHeavyWeightComponent(){
        return isSingleHeavyWeightComponent;
    }

    
    /** Facade method used to allow mixing of lightweight and heavyweight components in the 
     * desktop.
     * <p>
     *  This method is a shortcut for : 
     * <pre>
     *        ToolTipManager.sharedInstance().setLightWeightPopupEnabled(false);
     *        JPopupMenu.setDefaultLightWeightPopupEnabled(false);        
     *        setLightweigthComponentEnabled(false);
     *        getAutoHidePolicy().setExpansionDuration(0);
     * </pre>
     */
    public static void initHeavyWeightUsage(){
        // for now, there are only two methods used.
        ToolTipManager.sharedInstance().setLightWeightPopupEnabled(false);
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);        
        setLightweigthComponentEnabled(false);
        getAutoHidePolicy().setExpansionDuration(0);
    }

    /** Facade method used to allow mixing of lightweight and heavyweight components in the 
     * desktop.
     */
    public static void initHeavyWeightUsage(boolean isSingleHeavyWeightComponent){
        initHeavyWeightUsage();
        setSingleHeavyWeightComponent(isSingleHeavyWeightComponent);
    }

    
    
    /** Convenience method to use the VLDocking 1.0 layout and border style (with shadows around dockables) */
    public static void setShadowDesktopStyle(){
      DockingUISettings.getInstance().installUI();
      UIManager.put("DockView.singleDockableBorder", new ShadowBorder());
      UIManager.put("DockView.tabbedDockableBorder", new ShadowBorder(false));
      UIManager.put("TabbedDockableContainer.tabPlacement", new Integer(SwingConstants.BOTTOM));      
    }

    /** Convenience method to use the VLDocking 2.0 layout and border style.
     * <p> 
     * The new "flat style" uses light borders around dockables and top tab placements.
     * <p>
     * This style is the new default one, so there is no need to call this method unless you want
     * to swap dynamically between desktop styles.
     */
    public static void setFlatDesktopStyle(){
      DockingUISettings.getInstance().installUI();
     
      // flat style is the default (outside : empty 1 pix / inside : hightlight-top-left + shadow-bottom-right
      Color shadow = UIManager.getColor("controlShadow");
      Color highlight = UIManager.getColor("controlLtHighlight");

      Border innerFlatSingleBorder =  BorderFactory.createCompoundBorder(
        BorderFactory.createMatteBorder(1,1,0,0, highlight),
        BorderFactory.createMatteBorder(0,0,1,1, shadow));

      Border flatSingleBorder = BorderFactory.createCompoundBorder(
          BorderFactory.createEmptyBorder(1,1,1,1), 
          innerFlatSingleBorder);
      UIManager.put("DockView.singleDockableBorder", flatSingleBorder);
      UIManager.put("DockView.tabbedDockableBorder", null);
      UIManager.put("TabbedDockableContainer.tabPlacement", new Integer(SwingConstants.TOP));      
    }

    /** Another docking style with ligh dots between dockables.
     */
    public static void setDottedDesktopStyle(){
      DockingUISettings.getInstance().installUI();
     
      Color shadow = UIManager.getColor("controlShadow");
     Color highlight = UIManager.getColor("controlLtHighlight");

      Border innerFlatSingleBorder =  BorderFactory.createCompoundBorder(
        BorderFactory.createMatteBorder(1,1,0,0, highlight),
        BorderFactory.createMatteBorder(0,0,1,1, shadow));
      
      UIManager.put("DockView.singleDockableBorder", innerFlatSingleBorder);
          //BorderFactory.createLineBorder(shadow));
      UIManager.put("DockView.tabbedDockableBorder", null);
      UIManager.put("TabbedDockableContainer.tabPlacement", new Integer(SwingConstants.TOP));      
      
      UIManager.put("SplitContainer.drawDotsDelimitors", Boolean.TRUE);
    }

    /** Another docking style with custom tiles between dockables.
     */
    public static void setCustomSplitDesktopStyle(BufferedImage horizontalTile, 
        BufferedImage verticalTile){
      
      DockingUISettings.getInstance().installUI();
           
      //UIManager.put("DockView.singleDockableBorder", null);
      UIManager.put("DockView.tabbedDockableBorder", null);
      UIManager.put("TabbedDockableContainer.tabPlacement", new Integer(SwingConstants.TOP));      
      
      UIManager.put("SplitContainer.drawDotsDelimitors", Boolean.FALSE);
      UIManager.put("SplitContainer.hImage", horizontalTile);
      UIManager.put("SplitContainer.vImage", verticalTile);
    
      UIManager.put("SplitContainer.useCustomImages", Boolean.TRUE);
    }
    
}
