/* Time-stamp: <2007-04-11 02:28:31 poser> */
/*
 * Copyright (C) 2006-2007 William J. Poser.
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of version 2.1 of the GNU Lesser General
 * Public License as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

/* Pass/return formats */
#define NS_TYPE_ULONG  0
#define NS_TYPE_STRING 1
#define NS_TYPE_MPZT 2

/* Number system type codes */
#define NS_TYPE_GUESS   0	/* Special value returned by GuessNumberSystem */
#define NS_TYPE_SAFE    1	/* Usable in either direction */
#define NS_TYPE_COVER   2	/* Cover system suitable for string->int only */
#define NS_TYPE_SPECIAL 3	/* Special value suitable for string->int only */

/* Number systems */
#define NS_ALLZERO (-2)
#define NS_UNKNOWN (-1)
#define NS_AEGEAN					 1
/* (Russian Braille)					 2 */
#define NS_ARABIC_WESTERN				 3
/* (Ewellic decimal)				 	 4 */
#define NS_ARABIC_ALPHABETIC				 5
/* (Ewellic hex)					 6 */
#define NS_ARMENIAN_ALPHABETIC				 7
#define NS_BALINESE					 9
#define NS_BENGALI					11
#define NS_BURMESE					13
#define NS_CHINESE_GENERIC				14 /* Only for string to int */
#define NS_CHINESE_SUZHOU				15
#define NS_CHINESE_REGULAR_TRADITIONAL			17
#define NS_CHINESE_MANDARIN_REGULAR_TRADITIONAL		18
#define NS_CHINESE_REGULAR_PLACE			19
#define NS_CHINESE_REGULAR_SIMPLIFIED			21
#define NS_CHINESE_MANDARIN_REGULAR_SIMPLIFIED		22
#define NS_CHINESE_LEGAL_TRADITIONAL			25
#define NS_CHINESE_MANDARIN_LEGAL_TRADITIONAL		26
#define NS_CHINESE_LEGAL_SIMPLIFIED			27
#define NS_CHINESE_MANDARIN_LEGAL_SIMPLIFIED		28
#define NS_CHINESE_JAPANESE_REGULAR_SIMPLIFIED		29
#define NS_CHINESE_JAPANESE_REGULAR_TRADITIONAL		30
#define NS_CHINESE_JAPANESE_REGULAR_PLACE		31
#define NS_CHINESE_JAPANESE_WESTERN_MIX			33
#define NS_CHINESE_JAPANESE_LEGAL_SIMPLIFIED		35
#define NS_CHINESE_JAPANESE_LEGAL_TRADITIONAL		36
#define NS_COMMON_BRAILLE				37
#define NS_CYRILLIC_ALPHABETIC				39
#define NS_DEVANAGARI					41
#define NS_EGYPTIAN					43
#define NS_ETHIOPIC					45
#define NS_EWELLIC_DECIMAL				 4
#define NS_EWELLIC_HEX					 6
#define NS_FRENCH_BRAILLE				46
#define NS_GLAGOLITIC_ALPHABETIC			47
#define NS_GREEK_ACROPHONIC				49
#define NS_GREEK_ALPHABETIC_UPPER			51
#define NS_GREEK_ALPHABETIC_LOWER			52
#define NS_GUJARATI					53
#define NS_GURMUKHI					55
#define NS_HEBREW_GENERIC				56 /* Only for string to int */
#define NS_HEBREW_EARLY					57
#define NS_HEBREW_LATE					59
#define NS_KANNADA					61
#define NS_KHAROSHTHI					63
#define NS_KHMER					65
#define NS_KLINGON					67
#define NS_LAO						69
#define NS_LIMBU					71
#define NS_MALAYALAM					73
#define NS_MAYAN					75
#define NS_MONGOLIAN					77
#define NS_MXEDRULI					78
#define NS_NEW_TAI_LUE					79
#define NS_NKO						81
#define NS_OLD_ITALIC					83
#define NS_OLD_PERSIAN					85
#define NS_ORIYA					87
#define NS_OSMANYA					89
#define NS_PERSO_ARABIC					91
#define NS_PHOENICIAN					93
#define NS_ROMAN_GENERIC				94 /* Only for string to int */
#define NS_ROMAN_UPPER					95
#define NS_ROMAN_LOWER					96
#define NS_RUSSIAN_BRAILLE				 2
#define NS_SINHALA					97
#define NS_TAMIL_GENERIC				100 /* Only for string to int */
#define NS_TAMIL_PLACE					101
#define NS_TAMIL_TRADITIONAL				103
#define NS_TELUGU					105
#define NS_TENGWAR_DECIMAL				107
#define NS_TENGWAR_DUODECIMAL				108
#define NS_THAI						109
#define NS_TIBETAN					111
#define NS_XUCURI_LOWER					112
#define NS_XUCURI_UPPER					114
#define NS_ALL  					115
#define NS_ANY  					117
#define NS_HEX						129
#define NS_HEX_LOWER  					118
#define NS_HEX_UPPER  					119
#define NS_WESTERN					120 /* For backwards compatibility */
#define NS_WESTERN_GENERIC				120 /* Only for string to int */
#define NS_WESTERN_LOWER				121
#define NS_WESTERN_UPPER				122
#define NS_CHINESE_COUNTING_ROD_GENERIC			123 /* Only for string to int */
#define NS_CHINESE_COUNTING_ROD_EARLY_WITH_ZERO		124
#define NS_CHINESE_COUNTING_ROD_LATE_WITH_ZERO		125
#define NS_CHINESE_COUNTING_ROD_EARLY_WITHOUT_ZERO	126
#define NS_CHINESE_COUNTING_ROD_LATE_WITHOUT_ZERO	127
#define NS_VERDURIAN					128
/* NS_HEX 						129 */

/* Error codes */
/* No error */
#define NS_ERROR_OKAY 0

/* String contains illegal character */
#define NS_ERROR_BADCHARACTER 128
/* Backward compatibility - deprecated */
#define NS_BADCHARACTER 128

/* Value does not fit into binary type */
#define NS_ERROR_DOESNOTFIT 129
/* Backward compatibility - deprecated */
#define NS_DOESNOTFIT 129

/* The number system identifier is unknown */
#define NS_ERROR_NUMBER_SYSTEM_UNKNOWN 130
/* Backward compatibility - deprecated */
#define NS_ERROR_UNKNOWN 130

/* The specified base is not acceptable */
#define NS_ERROR_BADBASE 131

/* The string contains a digit too large for the base */
#define NS_ERROR_NOTCONSISTENTWITHBASE 132

/* Storage allocation failed */
#define NS_ERROR_OUTOFMEMORY 133

/* Number is larger than is representable in the number system  */
#define NS_ERROR_RANGE 134

/* The string contains a character outside the BMP */
#define NS_ERROR_OUTSIDE_BMP 135

/* The number system cannot represent zero */
#define NS_ERROR_NOZERO 136

/*
 * The string is not a valid number in the specified number system 
 * for a reason other than one of those specified above, e.g. it lacks
 * a required number marker.
 */
#define NS_ERROR_ILLFORMED 137
