package org.netbeans.modules.options.editor;

import org.netbeans.editor.BaseKit;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsNames;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.modules.options.macros.MacroDialogSupport;
import org.openide.modules.ModuleInstall;

/**
 * Manages a module's lifecycle. Remember that an installer is optional and
 * often not needed at all.
 */
public final class Installer extends ModuleInstall {
    
    public @Override void restored() {
        Settings.addInitializer(new MacrosSettingsInitializer());
    }
    
    public @Override void close() {
        finish();
    }
    
    public @Override void uninstalled() {
        finish();
    }
    
    private void finish() {
        Settings.removeInitializer(MacrosSettingsInitializer.NAME);
        Settings.reset();
    }

    private static final class MacrosSettingsInitializer extends Settings.AbstractInitializer {
        
        static final String NAME = "macros-settings-initializer"; // NOI18N
        
        MacrosSettingsInitializer() {
            super(NAME);
        }

        public void updateSettingsMap(Class kitClass, java.util.Map settingsMap) {
            if (kitClass == BaseKit.class) {
                SettingsUtil.updateListSetting(settingsMap,
                    SettingsNames.CUSTOM_ACTION_LIST,
                    new Object[] { 
                        new MacroDialogSupport.StartMacroRecordingAction(),
                        new MacroDialogSupport.StopMacroRecordingAction()
                    }
                );
            }
        }
        
    } // End of MacrosSettingsInitializer class
    
}
