package org.jboss.logging.jdk;

import java.util.logging.Level;

/**
 *
 */
public final class JBossLevel extends Level {
   protected JBossLevel(final String name, final int value) {
      super(name, value);
   }

   protected JBossLevel(final String name, final int value, final String resourceBundleName) {
      super(name, value, resourceBundleName);
   }

   public static final JBossLevel FATAL = new JBossLevel("FATAL", 1100);
   public static final JBossLevel ERROR = new JBossLevel("ERROR", 1000);
   public static final JBossLevel WARN = new JBossLevel("WARN", 900);
   public static final JBossLevel INFO = new JBossLevel("INFO", 800);
   public static final JBossLevel DEBUG = new JBossLevel("DEBUG", 500);
   public static final JBossLevel TRACE = new JBossLevel("TRACE", 400);
}
