/*
 * JBoss, Home of Professional Open Source
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.cache.loader;

import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.factories.XmlConfigurationParser;
import org.jboss.cache.util.TestingUtil;
import org.jboss.cache.xml.XmlHelper;
import org.testng.annotations.Test;
import org.w3c.dom.Element;

import java.io.File;

/**
 * Tests basic functionality of a chaining cache loader with 2 different loaders
 *
 * @author <a href="mailto:manik@jboss.org">Manik Surtani (manik@jboss.org)</a>
 */
@Test(groups = {"functional"})
public class ChainingCacheLoaderBasicTest extends CacheLoaderTestsBase
{
   private String loc1 = System.getProperty("java.io.tmpdir", ".") + File.separator + "JBossCache-ChainingCacheLoaderBasicTest-1";
   private String loc2 = System.getProperty("java.io.tmpdir", ".") + File.separator + "JBossCache-ChainingCacheLoaderBasicTest-2";

   public ChainingCacheLoaderBasicTest()
   {
      File dir1 = new File(loc1);
      File dir2 = new File(loc2);

      if (!dir1.exists()) dir1.mkdirs();
      if (!dir2.exists()) dir2.mkdirs();
   }

   protected void configureCache() throws Exception
   {
      cache.getConfiguration().setCacheLoaderConfig(getCacheLoaderConfig(loc1, loc2));
      TestingUtil.recursiveFileRemove(loc1);
      TestingUtil.recursiveFileRemove(loc2);

   }

   protected CacheLoaderConfig getCacheLoaderConfig(String loc1, String loc2) throws Exception
   {
      String xml = "<config>\n" +
                   "<passivation>false</passivation>\n" +
                   "<preload></preload>\n" +
                   "<cacheloader>\n" +
                   "<class>org.jboss.cache.loader.FileCacheLoader</class>\n" +
                   "<properties>" +
                   " location=" + loc1 + "\n" +
                   "</properties>\n" +
                   "<async>false</async>\n" +
                   "<fetchPersistentState>true</fetchPersistentState>\n" +
                   "</cacheloader>\n" +
                   "<cacheloader>\n" +
                   "<class>org.jboss.cache.loader.FileCacheLoader</class>\n" +
                   "<properties>" +
                   " location=" + loc2 + "\n" +
                   "</properties>\n" +
                   "<async>false</async>\n" +
                   "<fetchPersistentState>false</fetchPersistentState>\n" +
                   "</cacheloader>\n" +
                   "</config>";
      Element element = XmlHelper.stringToElement(xml);
      return XmlConfigurationParser.parseCacheLoaderConfig(element);
   }
}
