@echo off
rem
rem  Invokes the 'ant.bat' script from the 'tools' module.
rem
rem  @author Jason Dillon <jason@planet57.com>
rem

rem $Id: build.bat 21628 2008-08-19 22:06:02Z pgier $

setlocal

set PROGNAME=%~nx0
set DIRNAME=%~dp0

rem Legacy shell support
if x%PROGNAME%==x set PROGNAME=build.bat
if x%DIRNAME%==x set DIRNAME=.\

rem If not started by the loader script then setup some values
if x%TOOLS_ROOT%==x set TOOLS_ROOT=%DIRNAME%..
if x%MODULE_ROOT%==x set MODULE_ROOT=.

rem Setup ant variables
set ANT=%TOOLS_ROOT%\bin\ant.bat
set ANT_HOME=%TOOLS_ROOT%
if x%ANT_LOGGER%==x set ANT_LOGGER=org.apache.tools.ant.NoBannerLogger
set ANT_OPTIONS=%ANT_OPTIONS% -logger %ANT_LOGGER%

rem Set the minimum and maximum VM heap size
if x%JVM_MS%==x set JVM_MS=32m
if x%JVM_MX%==x set JVM_MX=640m
if x%ANT_OPTS%==x set ANT_OPTS=-Xms%JVM_MS% -Xmx%JVM_MX%

rem Save the arguments to the script
set ARGS=%*

rem Ignore the user's classpath
set CLASSPATH=

rem Start'er up yo
goto main

:debug
if not x%DEBUG%==x echo %PROGNAME%: %*
goto :EOF

:set-jaxp
set ANT_OPTS=%ANT_OPTS% -Djavax.xml.parsers.DocumentBuilderFactory=%1
set ANT_OPTS=%ANT_OPTS% -Djavax.xml.parsers.SAXParserFactory=%2
goto :EOF

:main
call :debug PROGNAME=%PROGNAME%
call :debug DIRNAME=%DIRNAME%
call :debug TOOLS_ROOT=%TOOLS_ROOT%
call :debug MODULE_ROOT=%MODULE_ROOT%

rem Setup JAXP impl
if x%JAXP%==x set JAXP=crimson
if %JAXP%==crimson call :set-jaxp org.apache.crimson.jaxp.DocumentBuilderFactoryImpl org.apache.crimson.jaxp.SAXParserFactoryImpl
if %JAXP%==xerces call :set-jaxp org.apache.xerces.jaxp.DocumentBuilderFactoryImpl org.apache.xerces.jaxp.SAXParserFactoryImpl
rem could complain if invalid JAXP here, but for now forget it

rem Check if the script exits
if exist %ANT% goto :execute-ant & goto :EOF

echo %PROGNAME%: *ERROR* The ant script does not exist:
echo %PROGNAME%:
echo %PROGNAME%:    %ANT%
echo %PROGNAME%:
echo %PROGNAME%: Please make sure you have checked out the 'tools'
echo %PROGNAME%: module and make sure it is up to date.
goto :EOF

:execute-ant
call :debug Ant JVM options: %ANT_OPTS%

echo Executing %ANT% %ANT_OPTIONS% %ARGS%
call %ANT% %ANT_OPTIONS% %ARGS%

if x%NOPAUSE%==x pause

goto :EOF
