package org.jboss.tools.buildmagic.task;

import java.util.Properties;

import junit.framework.TestCase;

public class ResolvePropertiesTestCase extends TestCase {

	public void testEvalExpr()
	{
		Properties props = new Properties();
		props.put("atest", "test");
		props.put("test1", "one");
		props.put("test2", "two");
		
		String expression = "This is test ${test1} ${test2} ${test3}";
		
		String evaluatedExpr = ResolveProperties.subst(expression, props, true);
		this.assertEquals("This is test one two ", evaluatedExpr);
		
		evaluatedExpr = ResolveProperties.subst(expression, props, false);
		this.assertEquals("This is test one two ${test3}", evaluatedExpr);
		
		/*evaluatedExpr = ResolveProperties.evalExpr(expression, props, true);
		this.assertEquals("This is test one two ", evaluatedExpr);
		
		evaluatedExpr = ResolveProperties.evalExpr(expression, props, false);
		this.assertEquals("This is test one two ${test3}", evaluatedExpr);*/
		
		String nestedExpr = "This is test ${${atest}1} ${test2} ${test3}";
		
		evaluatedExpr = ResolveProperties.subst(nestedExpr, props, false);
		//this.assertEquals("This is test one two ${test3}", evaluatedExpr);
		
		
		//System.out.println(evaluatedExpr);
	}
}
