/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/

package org.jboss.tools.buildmagic.task;

import java.util.Map;

import org.apache.tools.ant.Task;
import org.apache.tools.ant.Project;

/**
 * A collection of task utilities.
 *
 * @version <pre>$Id: Tasks.java 21373 2008-08-05 19:10:51Z pgier $</pre>
 * @author  <a href="mailto:jason@planet57.com">Jason Dillon</a>
 */
public class Tasks
{
   /**
    * Determine if a task should execute based on the given if and unless
    * condtions.
    *
    * @param map       The properties map.
    * @param _if       The <em>if</em> condition.
    * @param unless    The <em>unless</em> condition.
    * @return          True if the task can execute.
    */
   public static boolean canExecute(final Map props,
                                    final String _if,
                                    final String unless)
   {
      if (_if != null && !props.containsKey(_if)) {
         return false;
      }
      
      if (unless != null && props.containsKey(unless)) {
         return false;
      }

      return true;
   }
   
   /**
    * Determine if a task should execute based on the given if and unless
    * condtions.
    *
    * @param project   The project to get properties from.
    * @param _if       The <em>if</em> condition.
    * @param unless    The <em>unless</em> condition.
    * @return          True if the task can execute.
    */
   public static boolean canExecute(final Project project,
                                    final String _if,
                                    final String unless)
   {
      return canExecute(project.getProperties(), _if, unless);
   }
   
   /**
    * Determine if a task should execute based on the given if and unless
    * condtions.
    *
    * @param task      The task to check.
    * @param _if       The <em>if</em> condition.
    * @param unless    The <em>unless</em> condition.
    * @return          True if the task can execute.
    */
   public static boolean canExecute(final Task task,
                                    final String _if,
                                    final String unless)
   {
      return canExecute(task.getProject(), _if, unless);
   }
}
